within AixLib.ThermalZones.HighOrder.Components.DryAir;
model InfiltrationRate_DIN12831
  "Heat flow caused by infiltration after european standard DIN EN 12831"
  extends Modelica.Thermal.HeatTransfer.Interfaces.Element1D;
  parameter Modelica.Units.SI.Volume room_V=50 "Volume of the room";
  parameter Real n50(unit = "h-1") = 4
    "Air exchange rate at 50 Pa pressure difference";
  parameter Real e = 0.03 "Coefficient of windshield";
  parameter Real eps = 1.0 "Coefficient of height";
  parameter Modelica.Units.SI.SpecificHeatCapacity c=1000
    "Specific heat capacity of air";
  parameter Modelica.Units.SI.Density rho=1.25 "Air density";
protected
  parameter Real InfiltrationRate = 2 * n50 * e * eps;
equation
  port_a.Q_flow = InfiltrationRate * room_V * c * rho * (port_a.T - port_b.T) / 3600;
  annotation(Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={                                                                                                                                          Rectangle(extent={{-100,100},{100,-100}},   lineColor = {0, 0, 0}, fillColor = {211, 243, 255},
            fillPattern =                                                                                                   FillPattern.Solid), Text(extent={{-40,0},{40,-62}},        lineColor = {0, 0, 0}, fillColor = {255, 255, 255},
            fillPattern =                                                                                                   FillPattern.Solid, textString = "Air"), Text(extent={{-80,60},{80,20}},      lineColor = {0, 0, 0}, fillColor = {255, 255, 0},
            fillPattern =                                                                                                   FillPattern.Solid, textString = "DIN 12381")}), Documentation(info="<html><p>
  <b><span style=\"color: #008000\">Overview</span></b>
</p>
<p>
  The <b>InfiltrationRate</b> model describes heat and mass transport
  by infiltration.
</p>
<p>
  <b><span style=\"color: #008000\">Concept</span></b>
</p>
<p>
  Air exchange coefficients at 50 Pa pressure difference between
  ambience and room air:
</p>
<table cellspacing=\"2\" cellpadding=\"0\" border=\"1\">
  <caption>
    coefficients
  </caption>
  <tr>
    <td>
      <p style=\"text-align:center;\"></p>
      <h4>
        Dwelling type
      </h4>
    </td>
    <td>
      <p style=\"text-align:center;\"></p>
      <h4>
        highly air tight
      </h4>
    </td>
    <td>
      <p style=\"text-align:center;\"></p>
      <h4>
        medium air tight
      </h4>
    </td>
    <td>
      <p style=\"text-align:center;\"></p>
      <h4>
        low air tight
      </h4>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        one-family dwelling
      </p>
    </td>
    <td>
      <p>
        &lt; 4
      </p>
    </td>
    <td>
      <p>
        4 - 10
      </p>
    </td>
    <td>
      <p>
        &gt; 10
      </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        multi-family dwelling/other
      </p>
    </td>
    <td>
      <p>
        &lt; 2
      </p>
    </td>
    <td>
      <p>
        2 - 5
      </p>
    </td>
    <td>
      <p>
        &gt; 5
      </p>
    </td>
  </tr>
</table>
<p>
  <br/>
  <br/>
  Reference values for air shielding value e:
</p>
<table cellspacing=\"2\" cellpadding=\"0\" border=\"1\">
  <caption>
    Reference
  </caption>
  <tr>
    <td></td>
    <td>
      <p style=\"text-align:center;\"></p>
      <h4>
        heated room without
      </h4>
      <p style=\"text-align:center;\">
        facade with openings
      </p>
      <p style=\"text-align:center;\">
        exposed to wind
      </p>
    </td>
    <td>
      <p style=\"text-align:center;\"></p>
      <h4>
        heated room with
      </h4>
      <p style=\"text-align:center;\">
        one facade with openings
      </p>
      <p style=\"text-align:center;\">
        exposed to wind
      </p>
    </td>
    <td>
      <p style=\"text-align:center;\"></p>
      <h4>
        heated room with more than
      </h4>
      <p style=\"text-align:center;\">
        one facade with openings
      </p>
      <p style=\"text-align:center;\">
        exposed to wind
      </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        no shielding
      </p>
    </td>
    <td>
      <p>
        0
      </p>
    </td>
    <td>
      <p>
        0.03
      </p>
    </td>
    <td>
      <p>
        0.05
      </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        moderate shielding
      </p>
    </td>
    <td>
      <p>
        0
      </p>
    </td>
    <td>
      <p>
        0.02
      </p>
    </td>
    <td>
      <p>
        0.03
      </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        well shielded
      </p>
    </td>
    <td>
      <p>
        0
      </p>
    </td>
    <td>
      <p>
        0.01
      </p>
    </td>
    <td>
      <p>
        0.02
      </p>
    </td>
  </tr>
</table>
<p>
  <br/>
  <br/>
  Reference values for height correction value ε:
</p>
<table cellspacing=\"2\" cellpadding=\"0\" border=\"1\">
  <caption>
    Reference
  </caption>
  <tr>
    <td>
      <h4>
        Height of room
      </h4>
    </td>
    <td>
      <p style=\"text-align:center;\">
        <br/>
        <b>ε</b>
      </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        0 - 10 m
      </p>
    </td>
    <td>
      <p>
        1
      </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        10 - 30 m
      </p>
    </td>
    <td>
      <p>
        1.2
      </p>
    </td>
  </tr>
  <tr>
    <td>
      <p>
        &gt; 30 m
      </p>
    </td>
    <td>
      <p>
        1.5
      </p>
    </td>
  </tr>
</table>
<p>
  <br/>
  <br/>
  <b><span style=\"color: #008000\">References</span></b>
</p>
<p>
  DIN EN 12831
</p>
<p>
  <b><span style=\"color: #008000\">Example Results</span></b>
</p>
<p>
  <a href=
  \"AixLib.Building.Components.Examples.DryAir.DryAir_test\">AixLib.Building.Components.Examples.DryAir.DryAir_test</a>
</p>
<ul>
  <li>
    <i>Mai 19, 2014&#160;</i> by Ana Constantin:<br/>
    Uses components from MSL and respects the naming conventions
  </li>
  <li>
    <i>May 02, 2013&#160;</i> by Ole Odendahl:<br/>
    Formatted documentation appropriately
  </li>
  <li>
    <i>August 2, 2011&#160;</i> by Ana Constantin:<br/>
    Implemented after a model from Time Haase.
  </li>
</ul>
</html>"), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2})));
end InfiltrationRate_DIN12831;
