within AixLib.Controls;
package OBC "Blocks and preconfigured control sequences"
  extends Modelica.Icons.Package;

annotation (
Documentation(info="<html>
<p>
Package that contains a library of elementary control blocks
based on ASHRAE Standard 231P,
and libraries for building control sequences.
</p>
<p>
These implementations have been developed
through the OpenBuildingControl (<a href=\"https://obc.lbl.gov\">obc.lbl.gov</a>) project
that develops a process and tools for the
performance evaluation, specification and verification
of building control sequences.
</p>
<p>
For a tutorial for how to implement control sequences using the
Control Description Language (CDL), see
<a href=\"modelica://AixLib.Examples.Tutorial.CDL\">
AixLib.Examples.Tutorial.CDL</a>.
</p>
</html>"),
Icon(graphics={Bitmap(extent={{-92,-98},{104,96}},
fileName="modelica://AixLib/Resources/Images/Controls/OBC/OBC_logo-only_150dpi.png")}));
end OBC;
