within AixLib.Fluid.Interfaces.Examples.BaseClasses;
partial model PrescribedOutletState "Test model for prescribed outlet state"

  replaceable package Medium = AixLib.Media.Air
     constrainedby Modelica.Media.Interfaces.PartialMedium  "Medium model";

  parameter Modelica.Units.SI.MassFlowRate m_flow_nominal=0.1
    "Nominal mass flow rate";

  AixLib.Fluid.Sources.Boundary_pT sin(
    redeclare package Medium = Medium,
    use_T_in=false,
    p(displayUnit="Pa"),
    T=293.15,
    nPorts=4) "Sink"
    annotation (Placement(transformation(extent={{-10,-10},{10,10}},rotation=180,origin={100,0})));
  AixLib.Fluid.Interfaces.PrescribedOutlet heaHigPow(
    redeclare package Medium = Medium,
    QMax_flow=1.0e10,
    mWatMax_flow = 0.001,
    m_flow_small=1E-4*abs(m_flow_nominal),
    show_T=true,
    m_flow_nominal=m_flow_nominal,
    energyDynamics=Modelica.Fluid.Types.Dynamics.FixedInitial)
    "Steady-state model of the heater with high capacity"
    annotation (Placement(transformation(extent={{-10,76},{10,96}})));
  Modelica.Blocks.Sources.CombiTimeTable setHeaHigPow(table=[
    0,    20.0, 0.012;
    120,  20.0, 0.012;
    500,  60.0, 0.020;
    800,  10.0, 0.005;
    1200, 30.0, 0.015],
    offset={273.15,0},
    smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments)
    "Setpoint heating and humidification"
    annotation (Placement(transformation(extent={{-60,110},{-40,130}})));
  AixLib.Fluid.Interfaces.PrescribedOutlet cooLimPow(
    redeclare package Medium = Medium,
    QMin_flow=-1000,
    mWatMin_flow = -0.001,
    m_flow_small=1E-4*abs(m_flow_nominal),
    show_T=true,
    m_flow_nominal=m_flow_nominal,
    energyDynamics=Modelica.Fluid.Types.Dynamics.FixedInitial)
    "Steady-state model of the cooler with limited capacity"
    annotation (Placement(transformation(extent={{-10,-10},{10,10}})));
  Modelica.Blocks.Sources.CombiTimeTable setCooLimPow(table=[
    0,    20.0, 0.008;
    120,  20.0, 0.008;
    500,  15.0, 0.004;
    800,  60.0, 0.015;
    1200, 10.0, 0.002],
    offset={273.15,0},
    smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments)
    "Setpoint cooling and dehumidification"
    annotation (Placement(transformation(extent={{-60,30},{-40,50}})));
  AixLib.Fluid.Interfaces.PrescribedOutlet heaCooUnl(
    redeclare package Medium = Medium,
    m_flow_small=1E-4*abs(m_flow_nominal),
    show_T=true,
    m_flow_nominal=m_flow_nominal,
    energyDynamics=Modelica.Fluid.Types.Dynamics.FixedInitial)
    "Steady-state model of the heater or cooler with unlimited capacity"
    annotation (Placement(transformation(extent={{-10,-70},{10,-50}})));
  AixLib.Fluid.Interfaces.PrescribedOutlet steSta(
    redeclare package Medium = Medium,
    m_flow_small=1E-4*abs(m_flow_nominal),
    show_T=true,
    m_flow_nominal=m_flow_nominal,
    energyDynamics=Modelica.Fluid.Types.Dynamics.SteadyState)
    "Steady-state model of the heater or cooler with unlimited capacity"
    annotation (Placement(transformation(extent={{-10,-100},{10,-80}})));
  Modelica.Blocks.Sources.CombiTimeTable setHeaCooUnl(table=[
    0,    20.0, 0.012;
    120,  20.0, 0.012;
    500,  15.0, 0.008;
    800,  10.0, 0.005;
    1200, 30.0, 0.015],
    offset={273.15,0},
    smoothness = Modelica.Blocks.Types.Smoothness.ConstantSegments)
    "Setpoint cooling, heating, dehumidification and humidification"
    annotation (Placement(transformation(extent={{-60,-40},{-40,-20}})));
  Modelica.Blocks.Sources.Ramp m_flow(
    height=-2*m_flow_nominal,
    duration=100,
    offset=m_flow_nominal,
    startTime=1000) "Mass flow rate"
    annotation (Placement(transformation(extent={{-130,-2},{-110,18}})));
  AixLib.Fluid.Sources.MassFlowSource_T sou1(
    redeclare package Medium = Medium,
    use_m_flow_in=true,
    T=293.15,
    nPorts=1) "Flow source"
    annotation (Placement(transformation(extent={{-90,76},{-70,96}})));
  AixLib.Fluid.Sources.MassFlowSource_T sou2(
    redeclare package Medium = Medium,
    use_m_flow_in=true,
    T=293.15,
    nPorts=1) "Flow source"
    annotation (Placement(transformation(extent={{-90,-10},{-70,10}})));
  AixLib.Fluid.Sources.MassFlowSource_T sou3(
    redeclare package Medium = Medium,
    use_m_flow_in=true,
    T=293.15,
    nPorts=1) "Flow source"
    annotation (Placement(transformation(extent={{-90,-70},{-70,-50}})));
  AixLib.Fluid.Sources.MassFlowSource_T sou4(
    redeclare package Medium = Medium,
    use_m_flow_in=true,
    T=293.15,
    nPorts=1) "Flow source"
    annotation (Placement(transformation(extent={{-90,-100},{-70,-80}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort THeaHigPowIn(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the inlet of heaHigPow"
    annotation (Placement(transformation(extent={{-60,76},{-40,96}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort THeaHigPowOut(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the outlet of heaHigPow"
    annotation (Placement(transformation(extent={{20,76},{40,96}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort TCooLimPowIn(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the inlet of cooLimPow"
    annotation (Placement(transformation(extent={{-60,-10},{-40,10}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort TCooLimPowOut(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the outlet of cooLimPow"
    annotation (Placement(transformation(extent={{20,-10},{40,10}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort THeaCooUnlIn(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the inlet of heaCooUnl"
    annotation (Placement(transformation(extent={{-60,-70},{-40,-50}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort THeaCooUnlOut(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the outlet of heaCooUnl"
    annotation (Placement(transformation(extent={{20,-70},{40,-50}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort TSteStaIn(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the inlet of steSta"
    annotation (Placement(transformation(extent={{-60,-100},{-40,-80}})));
  AixLib.Fluid.Sensors.TemperatureTwoPort TSteStaOut(
    redeclare final package Medium = Medium,
    final m_flow_nominal=m_flow_nominal,
    final tau=0) "Temperature sensor at the outlet of steSta"
    annotation (Placement(transformation(extent={{20,-100},{40,-80}})));
equation

  connect(m_flow.y, sou1.m_flow_in) annotation (Line(
      points={{-109,8},{-100,8},{-100,94},{-92,94}},
      color={0,0,127}));
  connect(m_flow.y, sou2.m_flow_in) annotation (Line(
      points={{-109,8},{-92,8}},
      color={0,0,127}));
  connect(m_flow.y, sou3.m_flow_in) annotation (Line(
      points={{-109,8},{-100,8},{-100,-52},{-92,-52}},
      color={0,0,127}));
  connect(m_flow.y, sou4.m_flow_in) annotation (Line(points={{-109,8},{-100,8},
          {-100,-82},{-92,-82}},color={0,0,127}));
  connect(sou1.ports[1], THeaHigPowIn.port_a)
    annotation (Line(points={{-70,86},{-60,86}}, color={0,127,255}));
  connect(THeaHigPowIn.port_b, heaHigPow.port_a)
    annotation (Line(points={{-40,86},{-10,86}}, color={0,127,255}));
  connect(heaHigPow.port_b, THeaHigPowOut.port_a)
    annotation (Line(points={{10,86},{20,86}}, color={0,127,255}));
  connect(THeaHigPowOut.port_b, sin.ports[1]) annotation (Line(points={{40,86},{
          50,86},{50,1.5},{90,1.5}}, color={0,127,255}));
  connect(sou2.ports[1], TCooLimPowIn.port_a)
    annotation (Line(points={{-70,0},{-60,0}}, color={0,127,255}));
  connect(TCooLimPowIn.port_b, cooLimPow.port_a)
    annotation (Line(points={{-40,0},{-10,0}}, color={0,127,255}));
  connect(cooLimPow.port_b, TCooLimPowOut.port_a)
    annotation (Line(points={{10,0},{20,0}}, color={0,127,255}));
  connect(TCooLimPowOut.port_b, sin.ports[2]) annotation (Line(points={{40,0},{52,
          0},{52,0.5},{90,0.5}}, color={0,127,255}));
  connect(sou3.ports[1], THeaCooUnlIn.port_a)
    annotation (Line(points={{-70,-60},{-60,-60}}, color={0,127,255}));
  connect(THeaCooUnlIn.port_b, heaCooUnl.port_a)
    annotation (Line(points={{-40,-60},{-10,-60}}, color={0,127,255}));
  connect(heaCooUnl.port_b, THeaCooUnlOut.port_a)
    annotation (Line(points={{10,-60},{20,-60}}, color={0,127,255}));
  connect(THeaCooUnlOut.port_b, sin.ports[3]) annotation (Line(points={{40,-60},
          {50,-60},{50,-0.5},{90,-0.5}}, color={0,127,255}));
  connect(sou4.ports[1], TSteStaIn.port_a)
    annotation (Line(points={{-70,-90},{-60,-90}}, color={0,127,255}));
  connect(TSteStaIn.port_b, steSta.port_a)
    annotation (Line(points={{-40,-90},{-10,-90}}, color={0,127,255}));
  connect(steSta.port_b, TSteStaOut.port_a)
    annotation (Line(points={{10,-90},{20,-90}}, color={0,127,255}));
  connect(TSteStaOut.port_b, sin.ports[4]) annotation (Line(points={{40,-90},{54,
          -90},{54,-1.5},{90,-1.5}}, color={0,127,255}));
  annotation (Diagram(coordinateSystem(preserveAspectRatio=false, extent={{-140,
            -120},{120,160}})),
    Documentation(info="<html>
<p>
Model that is used as the base class for models that
demonstrates the use of an ideal heater and an ideal cooler,
or an ideal humidifier and dehumidifier.
</p>
<p>
The model on the top has almost unlimited positive capacity (<code>Q_flow_nominal = 1.0e10</code> Watts),
and hence its outlet temperature always reaches the set points.
</p>
<p>
The model in the middle has a limited negative capacitiy (<code>Q_flow_nominal = 1000</code> Watts), and hence
its outlet state reaches only a limited value corresponding to its
maximum negative capacity.
</p>
<p>
The model at the bottom has unlimited capacity.
</p>
<p>
At <i>t=1000</i> second, the flow reverses its direction.
</p>
<p>
Each flow leg has the same mass flow rate. There are three mass flow sources
as using one source only would yield a nonlinear system of equations that
needs to be solved to determine the mass flow rate distribution.
</p>
</html>", revisions="<html>
<ul>
<li>
August 5, 2024, by Hongxiang Fu:<br/>
Added two-port temperature sensors to replace <code>sta_*.T</code>
in reference results. This is for
<a href=\"https://github.com/ibpsa/modelica-ibpsa/issues/1913\">IBPSA #1913</a>.
</li>
<li>
May 3, 2017, by Michael Wetter:<br/>
First implementation.
</li>
</ul>
</html>"),  
   __Dymola_LockedEditing="Model from IBPSA");
end PrescribedOutletState;
