within AixLib.DataBase.ThermalZones.SwimmingFacility;
record Technichal "Swimming facility - Technical rooms"
  extends AixLib.DataBase.ThermalZones.ZoneBaseRecord(
    T_start = 298.15,
    withAirCap = true,
    VAir = 1251.545,
    AZone = 369.1,
    hRad = 4.999999999999999,
    lat = 0.88645272708792,
    nOrientations = 4,
    AWin = {0.001, 8.64, 0.001, 6.04},
    ATransparent = {0.001, 8.64, 0.001, 6.04},
    hConWin = 2.7,
    RWin = 0.07363309365761349,
    gWin = 0.67,
    UWin= 0.7993916878977316,
    ratioWinConRad = 0.029999999999999992,
    AExt = {0.001, 41.0, 0.001, 62.5},
    hConExt = 2.7,
    nExt = 1,
    RExt = {0.0004121563761613994},
    RExtRem = 0.0395915230647488,
    CExt = {42090197.17545912},
    AInt = 244.6741,
    hConInt = 2.6999999999999997,
    nInt = 1,
    RInt = {0.0008142137828887332},
    CInt = {31423590.247506615},
    AFloor = 466.1496,
    hConFloor = 1.7000000000000002,
    nFloor = 1,
    RFloor = {0.0001405991584732067},
    RFloorRem =  0.00549087052326128,
    CFloor = {241207146.17223492},
    ARoof = 137.6,
    hConRoof = 1.7000000000000006,
    nRoof = 1,
    RRoof = {0.0002092903359965459},
    RRoofRem = 0.04662821312469006,
    CRoof = {4123788.490763755},
    nOrientationsRoof = 1,
    tiltRoof = {0.0},
    aziRoof = {0.0},
    wfRoof = {1.0},
    aRoof = 0.5,
    aExt = 0.5,
    TSoil=286.15,
    hConWallOut = 20.0,
    hRadWall = 5.0,
    hConWinOut = 19.999999999999996,
    hConRoofOut = 20.000000000000004,
    hRadRoof = 5.0,
    tiltExtWalls = {1.5707963267948966, 1.5707963267948966, 1.5707963267948966, 1.5707963267948966},
    aziExtWalls = {0.0, 1.5707963267948966, -1.5707963267948966, 3.141592653589793},
    wfWall = {9.661649050259899e-06, 0.39612761106065586, 9.661649050259899e-06, 0.6038530656412436},
    wfWin = {6.811061163329247e-05, 0.588475684511647, 6.811061163329247e-05, 0.41138809426508643},
    wfGro = 0.0,
    specificPeople = 0.025,
    internalGainsMoistureNoPeople = 0.0,
    fixedHeatFlowRatePersons = 90,
    activityDegree = 2.0,
    ratioConvectiveHeatPeople = 0.5,
    internalGainsMachinesSpecific = 0.0,
    ratioConvectiveHeatMachines = 0.75,
    lightingPowerSpecific = 11.3,
    ratioConvectiveHeatLighting = 0.9,
    useConstantACHrate = true,
    baseACH = 0.5,
    maxUserACH = 1.0,
    maxOverheatingACH = {3.0, 2.0},
    maxSummerACH = {1.0, 283.15, 290.15},
    winterReduction = {0.2, 273.15, 283.15},
    maxIrr = {100.0, 100.0, 100.0, 100.0},
    shadingFactor = {1.0, 1.0, 1.0, 1.0},
    withAHU = true,
    minAHU = 0.0,
    maxAHU = 0.5,
    hHeat = 100000.0,
    lHeat = 0,
    KRHeat = 10000,
    TNHeat = 300,
    HeaterOn = false,
    hCool = 0,
    lCool = -100000.0,
    KRCool = 10000,
    TNCool = 1,
    heaLoadFacOut=0,
    heaLoadFacGrd=0,
    CoolerOn = false,
    withIdealThresholds = false,
    TThresholdHeater = 288.15,
    TThresholdCooler = 295.15);
  annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)));
end Technichal;
