﻿within AixLib.DataBase.ThermalZones;
record Office_1995_1000 "Office zone from 1995 with 1000 m² area and without heater"
  extends AixLib.DataBase.ThermalZones.ZoneBaseRecord(
    T_start=293.15,
    withAirCap=true,
    VAir=3000.0,
    AZone=1000.0,
    hRad=5.0,
    lat=0.88645272708792,
    nOrientations=6,
    AWin={67.74387527779635,0.0,67.74387527779635,4.977702139977209,0.0,
        4.977702139977209},
    ATransparent={67.74387527779635,0.0,67.74387527779635,4.977702139977209,0.0,
        4.977702139977209},
    hConWin=2.7,
    RWin=0.002462879436498116,
    gWin=0.67,
    UWin=1.8936557576825377,
    ratioWinConRad=0.03,
    AExt={195.06993119118175,1150.0,195.06993119118175,14.33339929187379,1150.0,
        14.33339929187379},
    hConExt=1.8540406189888072,
    nExt=1,
    RExt={1.2309857473569378e-05},
    RExtRem=0.0006398094136154137,
    CExt={688126422.5512525},
    AInt=1500.0,
    hConInt=2.7000000000000006,
    nInt=1,
    RInt={8.239105439369481e-05},
    CInt={93700288.5961044},
    AFloor=0.0,
    hConFloor=0.0,
    nFloor=1,
    RFloor={0.00001},
    RFloorRem=0.00001,
    CFloor={0.00001},
    ARoof=0.0,
    hConRoof=0.0,
    nRoof=1,
    RRoof={0.00001},
    RRoofRem=0.00001,
    CRoof={0.00001},
    nOrientationsRoof=1,
    tiltRoof={0.0},
    aziRoof={0.0},
    wfRoof={0.0},
    aRoof=0.0,
    aExt=0.5,
    TSoil=286.15,
    hConWallOut=20.000000000000004,
    hRadWall=5.0,
    hConWinOut=20.0,
    hConRoofOut=0.0,
    hRadRoof=0.0,
    tiltExtWalls={1.5707963267948966,0.0,1.5707963267948966,1.5707963267948966,
        0.0,1.5707963267948966},
    aziExtWalls={0.0,0.0,3.141592653589793,-1.5707963267948966,0.0,
        1.5707963267948966},
    wfWall={0.06949860286083018,0.3828656673402791,0.06949860286083018,
        0.005106636471078391,0.0,0.005106636471078391},
    wfWin={0.46577561765897135,0.0,0.46577561765897135,0.034224382341028765,0.0,
        0.034224382341028765},
    wfGro=0.4679238539959038,
    specificPeople=0.07142857142857142,
    fixedHeatFlowRatePersons=70,
    internalGainsMoistureNoPeople=0.5,
    activityDegree=1.2,
    ratioConvectiveHeatPeople=0.5,
    internalGainsMachinesSpecific=7.0,
    ratioConvectiveHeatMachines=0.75,
    lightingPowerSpecific=12.5,
    ratioConvectiveHeatLighting=0.9,
    useConstantACHrate=true,
    baseACH=0.2,
    maxUserACH=1.0,
    maxOverheatingACH={3.0,2.0},
    maxSummerACH={1.0,283.15,290.15},
    winterReduction={0.2,273.15,283.15},
    maxIrr={100.0,9999.9,100.0,100.0,9999.9,100.0},
    shadingFactor={1.0,1.0,1.0,1.0,1.0,1.0},
    withAHU=false,
    minAHU=0.0,
    maxAHU=2.6,
    hHeat=43939.72775558922,
    lHeat=0,
    KRHeat=100,
    TNHeat=50,
    HeaterOn=false,
    hCool=0,
    lCool=-43939.72775558922,
    KRCool=10000,
    TNCool=1,
    heaLoadFacOut=0,
    heaLoadFacGrd=0,
    CoolerOn=false,
    withIdealThresholds=false,
    TThresholdHeater=288.15,
    TThresholdCooler=295.15);

end Office_1995_1000;
