encapsulated model SpringMassSystem
  "Mass attached with a spring to the world frame"
  import Modelica.Icons;
  import Modelica.Mechanics.MultiBody;
  import Modelica.Mechanics.Rotational;
  import Modelica;
  extends Icons.Example;
  parameter Boolean animation=true "= true, if animation shall be enabled";
  annotation (
    experiment(StopTime=5),
    Coordsys(
      extent=[-100, -100; 100, 100],
      grid=[2, 2],
      component=[20, 20]),
    Window(
      x=0.29,
      y=0,
      width=0.71,
      height=0.85),
    Diagram,
    Documentation(info="<html>
<p>
This example shows the two different ways how force laws
can be utilized:
</p>
<ul>
<li>In the left system a body is attached via a prismatic
    joint to the world frame. The prismatic joint has two
    1-dimensional translational flanges (called \"bearing\" and \"axis\")
    that allows to connect elements from the Modelica.Mechanics.Translational
    library between the bearing and the axis connector. The effect is
    that the force generated by the 1-dimensional elements acts as driving
    force in the axis of the prismatic joint. In the example a simple
    spring is used.<br>
    The advantage of this approach is that the many elements from the
    Translational library can be easily used here and that this implementation
    is usually more efficient as when using 3-dimensional springs.</li>
<li>In the right system the same model is defined. The difference is
    that a 3-dimensional spring from the Modelica.Mechanics.MultiBody.Forces library is used.
    This has the advantage to get a nice animation of the force component.</li>
</ul>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Examples/Elementary/SpringMassSystem.png\"
ALT=\"model Examples.Elementary.SpringMassSystem\">
</p>
</html>"));
  inner Modelica.Mechanics.MultiBody.World world annotation (extent=[-80, 20; -60, 40]);
  Modelica.Mechanics.MultiBody.Joints.ActuatedPrismatic p1(
    initType=Modelica.Mechanics.MultiBody.Types.Init.PositionVelocity,
    n={0,-1,0},
    s_offset=0.1,
    animation=animation,
    enforceStates=true,
    boxWidth=0.05) annotation (extent=[-30, -20; -10, 0], rotation=-90);
  Modelica.Mechanics.Translational.Spring spring1(c=30)
    annotation (extent=[0, -20; 20, 0], rotation=-90);
  Modelica.Mechanics.MultiBody.Parts.Body body1(
    m=1,
    sphereDiameter=0.2,
    animation=animation) annotation (extent=[-10, -60; -30, -40], rotation=-90);
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation bar1(animation=animation, r={0.3,0,0})
    annotation (extent=[-46, 20; -26, 40]);
  Modelica.Mechanics.MultiBody.Parts.FixedTranslation bar2(animation=animation, r={0.3,0,0})
    annotation (extent=[0, 20; 20, 40]);
  Modelica.Mechanics.MultiBody.Parts.Body body2(
    m=1,
    sphereDiameter=0.2,
    animation=animation) annotation (extent=[60, -60; 40, -40], rotation=-90);
  Modelica.Mechanics.MultiBody.Joints.ActuatedPrismatic p2(
    initType=Modelica.Mechanics.MultiBody.Types.Init.PositionVelocity,
    n={0,-1,0},
    s_offset=0.1,
    animation=animation,
    enforceStates=true,
    boxWidth=0.05) annotation (extent=[40, -20; 60, 0], rotation=-90);
  Modelica.Mechanics.MultiBody.Forces.Spring spring2(
    c=30,
    s_unstretched=0.1,
    width=0.1) annotation (extent=[80, -20; 100, 0], rotation=-90);
equation
  connect(body1.frame_a, p1.frame_b)
    annotation (points=[-20,-40; -20,-20], style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
  connect(world.frame_b, bar1.frame_a)
    annotation (points=[-60,30; -46,30], style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
  connect(bar1.frame_b, p1.frame_a) annotation (points=[-26,30; -20,30; -20,0],
      style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
  connect(p1.bearing, spring1.flange_a)
    annotation (points=[-14, -6; -8, -6; -8, 0; 10, 0], style(color=58));
  connect(spring1.flange_b, p1.axis) annotation (points=[10, -20; 10, -30; -8,
        -30; -8, -18; -14, -18], style(color=58));
  connect(bar1.frame_b, bar2.frame_a)
    annotation (points=[-26,30; 0,30], style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
  connect(bar2.frame_b, p2.frame_a)
    annotation (points=[20,30; 50,30; 50,0], style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
  connect(p2.frame_b, body2.frame_a)
    annotation (points=[50,-20; 50,-40], style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
  connect(bar2.frame_b, spring2.frame_a)
    annotation (points=[20,30; 90,30; 90,0], style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
  connect(body2.frame_a, spring2.frame_b) annotation (points=[50,-40; 90,-40;
        90,-20], style(
      color=10,
      rgbcolor={95,95,95},
      thickness=2));
end SpringMassSystem;
