<img src="https://github.com/modelica/ModelicaStandardLibrary/raw/master/Modelica/Resources/Images/Logos/Modelica_Libraries.svg?sanitize=true#gh-light-mode-only" alt="Modelica Libraries Logo" width="250px"><img src="https://github.com/modelica/ModelicaStandardLibrary/raw/master/Modelica/Resources/Images/Logos/Modelica_Libraries_dark.svg?sanitize=true#gh-dark-mode-only" alt="Modelica Libraries Logo" width="250px">

# Modelica Standard Library

Free library from the Modelica Association to model mechanical (1D/3D), electrical (analog, digital, machines), magnetic, thermal, fluid, control systems and hierarchical state machines. Also numerical functions and functions for strings, files and streams are included.

## Library description

Package `Modelica` is a free library that is developed together with the Modelica language from the Modelica Association. It is also called *Modelica Standard Library*. It provides model components and standard component interfaces from many engineering domains. Each model comes with [documentation](https://doc.modelica.org/) included. The generous [license conditions](LICENSE) allow usage in commercial products.

Note, the usage of a Modelica library requires a Modelica simulation environment, [see the tools page](https://modelica.org/tools), and that such an environment usually already includes the Modelica standard library. It is possible that the demo version of the commercial tools will not allow to simulate non-trivial examples from the library.

![ModelicaLibraries](Modelica/Resources/Images/UsersGuide/ModelicaLibraries.png)

## Current release

[Modelica Standard Library v4.0.0 (2020-06-04)](https://github.com/modelica/ModelicaStandardLibrary/releases/tag/v4.0.0)

## Older Releases

Browse the [Releases](https://github.com/modelica/ModelicaStandardLibrary/releases) page in order to get access to older releases of the Modelica Standard Library.

## License

This Modelica package is free software and the use is completely at your own risk;
it can be redistributed and/or modified under the terms of the [3-Clause BSD License](LICENSE).

## Status

[![CI checks](https://github.com/modelica/ModelicaStandardLibrary/workflows/CI/badge.svg)](https://github.com/modelica/ModelicaStandardLibrary/actions) [![CLA assistant](https://cla-assistant.io/readme/badge/modelica/ModelicaStandardLibrary)](https://cla-assistant.io/modelica/ModelicaStandardLibrary) 
[![Modelica v4.1.0-dev regression test](https://img.shields.io/badge/dynamic/xml?url=https%3A%2F%2Fwww.ltx.de%2Fdownload%2FMA%2FCompare_MSL_v4.1.0%2FTestruns%2FDymola%2FModelica%2Ftestrun_report.html&query=%2F%2Fspan%5B%40class%3D'has-text-success'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-danger'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-warning'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-timeout'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-grey'%5D&label=Modelica%20v4.1.0-dev%20regression%20test)](https://www.ltx.de/download/MA/Compare_MSL_v4.1.0/comparison_report_overview.html)
[![ModelicaTest v4.1.0-dev regression test](https://img.shields.io/badge/dynamic/xml?url=https%3A%2F%2Fwww.ltx.de%2Fdownload%2FMA%2FCompare_MSL_v4.1.0%2FTestruns%2FDymola%2FModelicaTest%2Ftestrun_report.html&query=%2F%2Fspan%5B%40class%3D'has-text-success'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-danger'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-warning'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-timeout'%5D%20%7C%20%2F%2Fspan%5B%40class%3D'has-text-grey'%5D&label=ModelicaTest%20v4.1.0-dev%20regression%20test)](https://www.ltx.de/download/MA/Compare_MSL_v4.1.0/comparison_report_overview.html)

## Development and contribution

The development is organised by the [Modelica Association Project - Libraries (MAP-LIB)](https://modelica.org/projects).
See also the [contribution guide](CONTRIBUTING.md) and the [MAP-LIB Project Rules](https://github.com/modelica/MAP-LIB_ProjectRules) for more information.

You may report any issues by using the [Issue Tracker](https://github.com/modelica/ModelicaStandardLibrary/issues).
