within Modelica;
package UsersGuide "User's Guide"
  extends Modelica.Icons.Information;

annotation (DocumentationClass=true, Documentation(info="<html>
<p>
Package <strong>Modelica</strong> is a <strong>standardized</strong> and <strong>pre-defined</strong> package
that is developed together with the Modelica language from the
Modelica Association, see
<a href=\"https://www.Modelica.org\">https://www.Modelica.org</a>.
It is also called <strong>Modelica Standard Library</strong>.
It provides constants, types, connectors, partial models and model
components in various disciplines.
</p>
<p>
This is a short <strong>User's Guide</strong> for
the overall library. Some of the main sublibraries have their own
User's Guides that can be accessed by the following links:
</p>

<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">
<tr>
  <td><a href=\"modelica://Modelica.ComplexBlocks.UsersGuide\">ComplexBlocks</a></td>
  <td>Library of basic input/output control blocks with Complex signals</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Electrical.Digital.UsersGuide\">Digital</a>
   </td>
   <td>Library for digital electrical components based on the VHDL standard
   (2-,3-,4-,9-valued logic)</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Fluid.Dissipation.UsersGuide\">Dissipation</a></td>
  <td>Library of functions for convective heat transfer and pressure loss characteristics</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Fluid.UsersGuide\">Fluid</a></td>
    <td>Library of 1-dim. thermo-fluid flow models using the Modelica.Media media description</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Thermal.FluidHeatFlow.UsersGuide\">FluidHeatFlow</a></td>
  <td>Library of simple components for 1-dimensional incompressible thermo-fluid flow models</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Magnetic.FluxTubes.UsersGuide\">FluxTubes</a>
    </td>
   <td>Library for modelling of electromagnetic devices with lumped magnetic networks</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Magnetic.FundamentalWave.UsersGuide\">FundamentalWave</a></td>
  <td>Library for magnetic fundamental wave effects in electric machines</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Magnetic.QuasiStatic.FundamentalWave.UsersGuide\">FundamentalWave</a></td>
  <td>Library for quasi-static fundamental wave electric machines</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Electrical.Machines.UsersGuide\">Machines</a></td>
  <td>Library for electric machines</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Media.UsersGuide\">Media</a>
    </td>
   <td>Library of media property models</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Mechanics.MultiBody.UsersGuide\">MultiBody</a>
    </td>
   <td>Library to model 3-dimensional mechanical systems</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Electrical.Polyphase.UsersGuide\">Polyphase</a></td>
  <td>Library for electrical components of one or more phases</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Electrical.PowerConverters.UsersGuide\">PowerConverters</a></td>
  <td>Library for rectifiers, inverters and DC/DC converters</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Electrical.QuasiStatic.UsersGuide\">QuasiStatic</a></td>
  <td>Library for quasi-static electrical single-phase and polyphase AC simulation</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Mechanics.Rotational.UsersGuide\">Rotational</a>
    </td>
   <td>Library to model 1-dimensional, rotational mechanical systems</td>
</tr>

<tr>
  <td><a href=\"modelica://Modelica.Electrical.Spice3.UsersGuide\">Spice3</a></td>
  <td>Library for components of the Berkeley SPICE3 simulator</td>
</tr>

<tr><td><a href=\"modelica://Modelica.StateGraph.UsersGuide\">StateGraph</a>
    </td>
   <td>Library to model discrete event and reactive systems by hierarchical state machines</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Mechanics.Translational.UsersGuide\">Translational</a>
    </td>
   <td>Library to model 1-dimensional, translational mechanical systems</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Units.UsersGuide\">Units</a> </td>
   <td>Library of type definitions</td>
</tr>

<tr><td><a href=\"modelica://Modelica.Utilities.UsersGuide\">Utilities</a>
    </td>
   <td>Library of utility functions especially for scripting (Files, Streams, Strings, System)</td>
</tr>
</table>

</html>"));
end UsersGuide;
