<img src="https://github.com/modelica/ModelicaStandardLibrary/raw/master/Modelica/Resources/Images/Logos/Modelica_Libraries.svg?sanitize=true" width="250px">

# Modelica Standard Library

Free library from the Modelica Association to model mechanical (1D/3D), electrical (analog, digital, machines), magnetic, thermal, fluid, control systems and hierarchical state machines. Also numerical functions and functions for strings, files and streams are included.

## Library description

Package `Modelica` is a free library that is developed together with the Modelica language from the Modelica Association. It is also called *Modelica Standard Library*. It provides model components and standard component interfaces from many engineering domains. Each model comes with [documentation](https://doc.modelica.org/) included. The generous [license conditions](LICENSE) allow usage in commercial products.

Note, the usage of a Modelica library requires a Modelica simulation environment, [see the tools page](https://www.modelica.org/tools/), and that such an environment usually already includes the Modelica standard library. It is possible that the demo version of the commercial tools will not allow to simulate non-trivial examples from the library.

![ModelicaLibraries](Modelica/Resources/Images/UsersGuide/ModelicaLibraries.png)

## Current release

[Modelica Standard Library v4.0.0 (2020-06-04)](https://github.com/modelica/ModelicaStandardLibrary/releases/tag/v4.0.0)

## Older Releases

Browse the [Releases](https://github.com/modelica/ModelicaStandardLibrary/releases) page in order to get access to older releases of the Modelica Standard Library.

## License

This Modelica package is free software and the use is completely at your own risk;
it can be redistributed and/or modified under the terms of the [3-Clause BSD License](LICENSE).

## Status

[![CI checks](https://travis-ci.org/modelica/ModelicaStandardLibrary.svg?branch=master)](https://travis-ci.org/modelica/ModelicaStandardLibrary) [![CLA assistant](https://cla-assistant.io/readme/badge/modelica/ModelicaStandardLibrary)](https://cla-assistant.io/modelica/ModelicaStandardLibrary)

## Development and contribution

The development is organised by the [Modelica Association Project - Libraries (MAP-LIB)](https://www.modelica.org/projects).
See also the [contribution guide](CONTRIBUTING.md) and the [MAP-LIB Project Rules](https://github.com/modelica/MAP-LIB_ProjectRules) for more information.

You may report any issues by using the [Issue Tracker](https://github.com/modelica/ModelicaStandardLibrary/issues).
