within Modelica.Clocked;
package UsersGuide "User's Guide"
  extends Modelica.Icons.Information;

  annotation (DocumentationClass=true, Documentation(info="<html>
<p>
Library <strong>Modelica.Clocked</strong> is a Modelica package
to precisely define and synchronize sampled data systems with different sampling rates. This package contains the <strong>user's guide</strong> for
the library and has the following content:
</p>
<ol>
<li><a href=\"modelica://Modelica.Clocked.UsersGuide.GettingStarted\">Getting started</a>
    contains an introduction to the most important features and how
    to use them.</li>
<li><a href=\"modelica://Modelica.Clocked.UsersGuide.Literature\">Literature</a>
    provides references that have been used to design and implement this
    library.</li>
<li><a href=\"modelica://Modelica.Clocked.UsersGuide.ReleaseNotes\">Release Notes</a>
    summarizes the differences between different versions of this library.</li>
<li><a href=\"modelica://Modelica.Clocked.UsersGuide.Requirements\">Requirements</a>
    sketches the requirements on a Modelica tool, in order that this library
    can be utilized.</li>
<li><a href=\"modelica://Modelica.Clocked.UsersGuide.Contact\">Contact</a>
    provides information about the authors of the library as well as
    acknowledgments.</li>
</ol>
</html>"));
end UsersGuide;
