within BioChem.Interfaces.Reactions;

partial model Bur "Bi-Uni reversible reaction"
  extends BioChem.Icons.Base;
  extends BioChem.Interfaces.Reactions.Basics.Reaction;
  extends BioChem.Interfaces.Reactions.Basics.TwoSubstratesReversible;
  extends BioChem.Interfaces.Reactions.Basics.OneProduct;
  BioChem.Units.StoichiometricCoefficient nS1 = 1 "Stoichiometric coefficient for substrate 1";
  BioChem.Units.StoichiometricCoefficient nS2 = 1 "Stoichiometric coefficient for substrate 2";
  BioChem.Units.StoichiometricCoefficient nP1 = 1 "Stoichiometric coefficient for the product";
equation
  s1.r = nS1 * rr;
  s2.r = nS2 * rr;
  p1.r = -nP1 * rr;
end Bur;
