﻿within TRANSFORM.Media.Fluids.Therminol_66;
package TableBasedTherminol66
// “DOWTHERM A Heat Transfer Fluid Product Technical Data.” 1997. Dow Chemical Company. http://msdssearch.dow.com/PublishedLiteratureDOWCOM/dh_0030/0901b803800303cd.pdf.

  extends TRANSFORM.Media.Interfaces.Fluids.TableBased(
    mediumName="Therminol 66",
    MM_const=0.252,
    T_min=Modelica.Units.Conversions.from_degC(0),
    T_max=Modelica.Units.Conversions.from_degC(380),
    TinK=false,
    T0=273.15,
    tableDensity=[0,1021.; 10,1014.; 20,1008.; 30,1001.; 40,995.2; 50,988.6; 60,
        981.9; 70,975.2; 80,968.5; 90,961.8; 100,955; 110,948.2; 120,941.4; 130,
        934.5; 140,927.6; 150,920.6; 160,913.6; 170,906.6; 180,899.5; 190,892.3;
        200,885.1; 210,877.8; 220,870.4; 230,863; 240,855.5; 250,847.9; 260,840.3;
        270,832.5; 280,824.6; 290,816.6; 300,808.5; 310,800.3; 320,792; 330,783.5;
        340,774.8; 350,765.9; 360,756.9; 370,747.7; 380,738.2],
    tableHeatCapacity=[0,1495; 10,1529; 20,1562; 30,1596; 40,1630; 50,1665; 60,1699;
        70,1733; 80,1768; 90,1803; 100,1837; 110,1873; 120,1908; 130,1943; 140,1978;
        150,2014; 160,2050; 170,2086; 180,2122; 190,2158; 200,2195; 210,2231; 220,
        2268; 230,2305; 240,2342; 250,2379; 260,2417; 270,2455; 280,2492; 290,2531;
        300,2569; 310,2608; 320,2647; 330,2686; 340,2726; 350,2766; 360,2806; 370,
        2847; 380,2889],
    tableConductivity=[0,0.118; 10,0.118; 20,0.118; 30,0.117; 40,0.117; 50,0.116;
        60,0.116; 70,0.115; 80,0.115; 90,0.114; 100,0.114; 110,0.113; 120,0.112;
        130,0.111; 140,0.111; 150,0.11; 160,0.109; 170,0.108; 180,0.107; 190,0.107;
        200,0.106; 210,0.105; 220,0.104; 230,0.103; 240,0.102; 250,0.1; 260,0.099;
        270,0.098; 280,0.097; 290,0.096; 300,0.095; 310,0.093; 320,0.092; 330,0.091;
        340,0.089; 350,0.088; 360,0.086; 370,0.085; 380,0.084],
    tableViscosity=[0,1324.87e-3; 10,344.26e-3; 20,123.47e-3; 30,55.6e-3; 40,29.5e-3;
        50,17.64e-3; 60,11.53e-3; 70,8.06e-3; 80,5.93e-3; 90,4.55e-3; 100,3.6e-3;
        110,2.92e-3; 120,2.42e-3; 130,2.05e-3; 140,1.75e-3; 150,1.52e-3; 160,1.34e-3;
        170,1.18e-3; 180,1.06e-3; 190,0.95e-3; 200,0.86e-3; 210,0.78e-3; 220,0.72e-3;
        230,0.66e-3; 240,0.61e-3; 250,0.57e-3; 260,0.53e-3; 270,0.49e-3; 280,0.46e-3;
        290,0.44e-3; 300,0.41e-3; 310,0.39e-3; 320,0.37e-3; 330,0.35e-3; 340,0.34e-3;
        350,0.32e-3; 360,0.31e-3; 370,0.3e-3; 380,0.28e-3],
    tableVaporPressure=[0,0; 10,0; 20,0; 30,0; 40,0; 50,0; 60,0; 70,10; 80,20; 90,
        30; 100,50; 110,80; 120,120; 130,180; 140,270; 150,400; 160,580; 170,830;
        180,1170; 190,1620; 200,2230; 210,3020; 220,4060; 230,5390; 240,7100; 250,
        9250; 260,11950; 270,15310; 280,19460; 290,24550; 300,30730; 310,38220;
        320,47200; 330,57940; 340,70680; 350,85740; 360,103420; 370,124090; 380,
        148130]);

  annotation (Documentation(info="<html>

</html>"));
end TableBasedTherminol66;
