within TRANSFORM.Fluid.Machines.BaseClasses.PumpCharacteristics.HomologousSets;
model Bingham "Bingham pump extracted from TRACE manuals"
  //https://www.nrc.gov/docs/ML0717/ML071720510.pdf pg 148-149 figures 2-61 and 2-63
  extends PartialHomoSet(
  table_BAN=[ 0.00, 0.80; 0.23, 0.80; 0.35, 0.87; 0.50, 0.93; 0.60, 0.95; 0.80, 0.96; 1.00, 1.00],
  table_BAD=[-1.00, 2.50;-0.80, 2.00;-0.60, 1.45;-0.46, 1.15;-0.30, 0.95;-0.13, 0.80; 0.00, 0.80],
  table_BAR=[-1.00,-2.00;-0.30,-1.50;-0.18,-1.35;-0.07,-1.00; 0.00,-0.92],
  table_BAT=[ 0.00,-0.92; 0.30,-0.60; 0.42,-0.40; 0.50,-0.05; 0.75, 0.25; 1.00, 0.57],
  table_BVN=[ 0.00,-1.00; 0.13,-0.80; 0.30,-0.60; 0.40,-0.40; 0.50, 0.10; 0.56, 0.20; 0.90, 0.80; 1.00, 1.00],
  table_BVD=[-1.00, 2.50;-0.65, 2.15;-0.40, 1.79;-0.30, 1.61;-0.13, 1.50; 0.00, 1.44],
  table_BVR=[-1.00,-2.00;-0.25,-1.80;-0.12,-1.50;-0.08,-1.40; 0.00,-1.00],
  table_BVT=[ 0.00, 1.44; 0.10, 1.40; 0.22, 1.20; 0.33, 1.10; 0.50, 1.00; 0.80, 0.80; 1.00, 0.57],
  table_HAN=[ 0.00, 1.38; 0.25, 1.38; 0.35, 1.35; 0.65, 1.20; 0.80, 1.10; 1.00, 1.00],
  table_HAD=[-1.00, 2.50;-0.90, 2.28;-0.63, 2.00;-0.55, 1.74;-0.50, 1.68;-0.42, 1.60;-0.15, 1.40; 0.00, 1.38],
  table_HAR=[-1.00,-2.00;-0.68,-1.50;-0.45,-1.00;-0.28,-0.40;-0.23,-0.27;-0.13,-0.20; 0.00,-0.10],
  table_HAT=[ 0.00,-0.10; 0.15, 0.05; 0.35, 0.20; 0.55, 0.30; 0.70, 0.40; 0.86, 0.60; 0.96, 0.80; 0.99, 0.90; 1.00, 1.00],
  table_HVN=[ 0.00,-1.02; 0.10,-0.90; 0.37,-0.50; 0.50,-0.25; 0.80, 0.40; 0.85, 0.60; 1.00, 1.00],
  table_HVD=[-1.00, 2.50;-0.90, 2.28;-0.63, 2.00;-0.55, 1.74;-0.50, 1.68;-0.42, 1.60;-0.15, 1.40; 0.00, 1.30],
  table_HVR=[-1.00,-2.00;-0.75,-1.94;-0.50,-1.80;-0.12,-1.20; 0.00,-1.02],
  table_HVT=[ 0.00, 1.30; 0.30, 1.10; 0.50, 1.00; 0.75, 0.88; 1.00, 1.00],
  tCCF = table_BAN[end,2],
  hCCF = table_HAN[end,2]);
  annotation (Icon(coordinateSystem(preserveAspectRatio=false)), Diagram(
        coordinateSystem(preserveAspectRatio=false)));
end Bingham;
