within TRANSFORM.Fluid.Examples.MSLFluid;
model BranchingDynamicPipes
  "Multi-way connections of pipes with dynamic momentum balance, pressure wave and flow reversal"
extends TRANSFORM.Icons.Example;
  replaceable package Medium=Modelica.Media.Air.MoistAir constrainedby Modelica.Media.Interfaces.PartialMedium;
  inner Modelica.Fluid.System system(energyDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
      momentumDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial)
    annotation (Placement(transformation(extent={{-90,70},{-70,90}})));
  TRANSFORM.Fluid.BoundaryConditions.Boundary_pT boundary1(
    nPorts=1,
    redeclare package Medium = Medium,
    p=150000) annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={0,-80})));
Pipes.GenericPipe_MultiTransferSurface pipe1(
    redeclare package Medium = Medium,
    energyDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    T_a_start=system.T_start,
    m_flow_a_start=0.02,
    exposeState_a=false,
    momentumDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    p_a_start=150000,
    p_b_start=130000,
    redeclare model Geometry =
        ClosureRelations.Geometry.Models.DistributedVolume_1D.StraightPipe (
        dimension=2.54e-2,
        length=50,
        nV=5,
        dheight=50),
    redeclare model FlowModel =
        ClosureRelations.PressureLoss.Models.DistributedPipe_1D.SinglePhase_Developed_2Region_NumStable)
    annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={0,-50})));
Pipes.GenericPipe_MultiTransferSurface pipe2(
    redeclare package Medium = Medium,
    use_HeatTransfer=true,
    m_flow_a_start=0.01,
    exposeState_a=true,
    exposeState_b=true,
    energyDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    T_a_start=system.T_start,
    momentumDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    redeclare model FlowModel =
        ClosureRelations.PressureLoss.Models.DistributedPipe_1D.SinglePhase_Developed_2Region_NumStable,
    redeclare model Geometry =
        ClosureRelations.Geometry.Models.DistributedVolume_1D.StraightPipe (
        dimension=2.54e-2,
        length=50,
        nV=5,
        dheight=25),
    p_a_start=130000,
    p_b_start=120000,
    redeclare model HeatTransfer =
        ClosureRelations.HeatTransfer.Models.DistributedPipe_1D_MultiTransferSurface.Nus_SinglePhase_2Region)
    annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={-20,-10})));
Pipes.GenericPipe_MultiTransferSurface pipe3(
    redeclare package Medium = Medium,
    m_flow_a_start=0.01,
    energyDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    T_a_start=system.T_start,
    exposeState_a=false,
    momentumDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    p_a_start=130000,
    p_b_start=120000,
    redeclare model Geometry =
        ClosureRelations.Geometry.Models.DistributedVolume_1D.StraightPipe (
        dimension=2.54e-2,
        length=25,
        nV=5,
        dheight=25),
    redeclare model FlowModel =
        ClosureRelations.PressureLoss.Models.DistributedPipe_1D.SinglePhase_Developed_2Region_NumStable)
    annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={20,-10})));
Pipes.GenericPipe_MultiTransferSurface pipe4(
    redeclare package Medium = Medium,
    energyDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    T_a_start=system.T_start,
    m_flow_a_start=0.02,
    exposeState_a=false,
    momentumDynamics=Modelica.Fluid.Types.Dynamics.SteadyStateInitial,
    p_a_start=120000,
    p_b_start=100000,
    redeclare model Geometry =
        ClosureRelations.Geometry.Models.DistributedVolume_1D.StraightPipe (
        dimension=2.54e-2,
        length=50,
        nV=5,
        dheight=50),
    redeclare model FlowModel =
        ClosureRelations.PressureLoss.Models.DistributedPipe_1D.SinglePhase_Developed_2Region_NumStable)
    annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=90,
        origin={0,30})));
  TRANSFORM.Fluid.BoundaryConditions.Boundary_pT boundary4(
    nPorts=1,
    redeclare package Medium = Medium,
    use_p_in=true,
    use_T_in=false,
    p=100000) annotation (Placement(transformation(
        extent={{10,-10},{-10,10}},
        rotation=90,
        origin={0,60})));
  Modelica.Blocks.Sources.Ramp ramp1(
    offset=1e5,
    startTime=2,
    height=1e5,
    duration=0) annotation (Placement(transformation(extent={{-40,70},{-20,90}})));
  Utilities.ErrorAnalysis.UnitTests unitTests(
    errorExpected=1,
    name="BranchingDynamicPipes_T",
    n=10,
    x=cat(
        1,
        pipe2.mediums.T,
        pipe2.mediums.p),
    x_reference=cat(
        1,
        timeTable_pipe2_T.y,
        timeTable_pipe2_p.y))
    annotation (Placement(transformation(extent={{80,80},{100,100}})));
  Modelica.Blocks.Sources.CombiTimeTable timeTable_pipe2_T(smoothness=Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
      table=[0,297.211,302.413,307.614,312.813,318.012; 0.02,297.211,302.413,307.614,
        312.813,318.012; 0.04,297.211,302.413,307.614,312.813,318.012; 0.06,297.211,
        302.413,307.614,312.813,318.012; 0.08,297.211,302.413,307.614,312.813,318.012;
        0.1,297.211,302.413,307.614,312.813,318.012; 0.12,297.211,302.413,307.614,
        312.813,318.012; 0.14,297.211,302.413,307.614,312.813,318.012; 0.16,297.211,
        302.413,307.614,312.813,318.012; 0.18,297.211,302.413,307.614,312.813,318.012;
        0.2,297.211,302.413,307.614,312.813,318.012; 0.22,297.211,302.413,307.614,
        312.813,318.012; 0.24,297.211,302.413,307.614,312.813,318.012; 0.26,297.211,
        302.413,307.614,312.813,318.012; 0.28,297.211,302.413,307.614,312.813,318.012;
        0.3,297.211,302.413,307.614,312.813,318.012; 0.32,297.211,302.413,307.614,
        312.813,318.012; 0.34,297.211,302.413,307.614,312.813,318.012; 0.36,297.211,
        302.413,307.614,312.813,318.012; 0.38,297.211,302.413,307.614,312.813,318.012;
        0.4,297.211,302.413,307.614,312.813,318.012; 0.42,297.211,302.413,307.614,
        312.813,318.012; 0.44,297.211,302.413,307.614,312.813,318.012; 0.46,297.211,
        302.413,307.614,312.813,318.012; 0.48,297.211,302.413,307.614,312.813,318.012;
        0.5,297.211,302.413,307.614,312.813,318.012; 0.52,297.211,302.413,307.614,
        312.813,318.012; 0.54,297.211,302.413,307.614,312.813,318.012; 0.56,297.211,
        302.413,307.614,312.813,318.012; 0.58,297.211,302.413,307.614,312.813,318.012;
        0.6,297.211,302.413,307.614,312.813,318.012; 0.62,297.211,302.413,307.614,
        312.813,318.012; 0.64,297.211,302.413,307.614,312.813,318.012; 0.66,297.211,
        302.413,307.614,312.813,318.012; 0.68,297.211,302.413,307.614,312.813,318.012;
        0.7,297.211,302.413,307.614,312.813,318.012; 0.72,297.211,302.413,307.614,
        312.813,318.012; 0.74,297.211,302.413,307.614,312.813,318.012; 0.76,297.211,
        302.413,307.614,312.813,318.012; 0.78,297.211,302.413,307.614,312.813,318.012;
        0.8,297.211,302.413,307.614,312.813,318.012; 0.82,297.211,302.413,307.614,
        312.813,318.012; 0.84,297.211,302.413,307.614,312.813,318.012; 0.86,297.211,
        302.413,307.614,312.813,318.012; 0.88,297.211,302.413,307.614,312.813,318.012;
        0.9,297.211,302.413,307.614,312.813,318.012; 0.92,297.211,302.413,307.614,
        312.813,318.012; 0.94,297.211,302.413,307.614,312.813,318.012; 0.96,297.211,
        302.413,307.614,312.813,318.012; 0.98,297.211,302.413,307.614,312.813,318.012;
        1,297.211,302.413,307.614,312.813,318.012; 1.02,297.211,302.413,307.614,
        312.813,318.012; 1.04,297.211,302.413,307.614,312.813,318.012; 1.06,297.211,
        302.413,307.614,312.813,318.012; 1.08,297.211,302.413,307.614,312.813,318.012;
        1.1,297.211,302.413,307.614,312.813,318.012; 1.12,297.211,302.413,307.614,
        312.813,318.012; 1.14,297.211,302.413,307.614,312.813,318.012; 1.16,297.211,
        302.413,307.614,312.813,318.012; 1.18,297.211,302.413,307.614,312.813,318.012;
        1.2,297.211,302.413,307.614,312.813,318.012; 1.22,297.211,302.413,307.614,
        312.813,318.012; 1.24,297.211,302.413,307.614,312.813,318.012; 1.26,297.211,
        302.413,307.614,312.813,318.012; 1.28,297.211,302.413,307.614,312.813,318.012;
        1.3,297.211,302.413,307.614,312.813,318.012; 1.32,297.211,302.413,307.614,
        312.813,318.012; 1.34,297.211,302.413,307.614,312.813,318.012; 1.36,297.211,
        302.413,307.614,312.813,318.012; 1.38,297.211,302.413,307.614,312.813,318.012;
        1.4,297.211,302.413,307.614,312.813,318.012; 1.42,297.211,302.413,307.614,
        312.813,318.012; 1.44,297.211,302.413,307.614,312.813,318.012; 1.46,297.211,
        302.413,307.614,312.813,318.012; 1.48,297.211,302.413,307.614,312.813,318.012;
        1.5,297.211,302.413,307.614,312.813,318.012; 1.52,297.211,302.413,307.614,
        312.813,318.012; 1.54,297.211,302.413,307.614,312.813,318.012; 1.56,297.211,
        302.413,307.614,312.813,318.012; 1.58,297.211,302.413,307.614,312.813,318.012;
        1.6,297.211,302.413,307.614,312.813,318.012; 1.62,297.211,302.413,307.614,
        312.813,318.012; 1.64,297.211,302.413,307.614,312.813,318.012; 1.66,297.211,
        302.413,307.614,312.813,318.012; 1.68,297.211,302.413,307.614,312.813,318.012;
        1.7,297.211,302.413,307.614,312.813,318.012; 1.72,297.211,302.413,307.614,
        312.813,318.012; 1.74,297.211,302.413,307.614,312.813,318.012; 1.76,297.211,
        302.413,307.614,312.813,318.012; 1.78,297.211,302.413,307.614,312.813,318.012;
        1.8,297.211,302.413,307.614,312.813,318.012; 1.82,297.211,302.413,307.614,
        312.813,318.012; 1.84,297.211,302.413,307.614,312.813,318.012; 1.86,297.211,
        302.413,307.614,312.813,318.012; 1.88,297.211,302.413,307.614,312.813,318.012;
        1.9,297.211,302.413,307.614,312.813,318.012; 1.92,297.211,302.413,307.614,
        312.813,318.012; 1.94,297.211,302.413,307.614,312.813,318.012; 1.96,297.211,
        302.413,307.614,312.813,318.012; 1.98,297.211,302.413,307.614,312.813,318.012;
        2,297.211,302.413,307.614,312.813,318.012; 2.02,297.211,302.413,307.614,
        312.813,318.012; 2.04,297.211,302.413,307.614,312.813,318.012; 2.06,297.211,
        302.413,307.614,312.813,318.012; 2.08,297.211,302.413,307.614,312.814,318.029;
        2.1,297.211,302.414,307.615,312.822,318.217; 2.12,297.211,302.414,307.62,
        312.905,319.354; 2.1317,297.212,302.415,307.637,313.094,321.069; 2.14,297.212,
        302.417,307.668,313.382,322.986; 2.16,297.226,302.448,307.94,315.097,329.105;
        2.16721,297.243,302.48,308.175,316.232,330.84; 2.18,297.326,302.611,308.932,
        318.922,332.643; 2.2,297.86,303.248,311.439,323.462,333.008; 2.22,299.895,
        305.109,315.534,326.219,332.673; 2.24,304.177,309.228,319.197,327.321,333.046;
        2.24855,305.683,311.633,320.274,327.659,333.198; 2.26,306.56,314.94,321.415,
        328.184,333.478; 2.28,307.118,319.307,323.42,329.478,333.928; 2.3,309.423,
        320.582,326.108,331.248,333.92; 2.30952,310.59,320.271,327.42,332.221,334.089;
        2.32,311.476,319.68,328.577,333.371,334.493; 2.34,312.328,319.064,329.379,
        335.573,335.812; 2.36,312.923,319.858,328.682,337.114,337.662; 2.38,314.3,
        321.302,328.28,337.25,339.352; 2.4,315.544,322.487,329.239,336.458,341.213;
        2.42,316.001,323.334,330.739,336.463,341.702; 2.44,316.719,324.055,331.846,
        337.943,341.608; 2.45435,317.424,324.608,332.417,339.448,342.178; 2.46,317.738,
        324.843,332.652,340.03,342.445; 2.48,318.651,325.799,333.779,341.675,343.326;
        2.48172,318.705,325.892,333.9,341.778,343.389; 2.5,319.061,326.978,335.343,
        342.527,343.869; 2.52,319.141,328.279,336.827,342.93,344.351; 2.54,319.406,
        329.36,337.713,343.484,345.249; 2.56,320.286,329.882,338.063,344.425,345.967;
        2.58,320.667,329.913,338.335,345.362,346.466; 2.6,320.906,329.771,338.759,
        345.857,346.964; 2.62,321.36,329.88,339.121,345.935,347.476; 2.64,322.016,
        330.428,339.221,345.903,347.766; 2.66,322.572,331.17,339.269,345.943,347.911;
        2.68,323.117,331.729,339.599,346.066,347.82; 2.7,323.662,332.051,340.2,346.28,
        347.888; 2.72,324.086,332.374,340.769,346.672,347.967; 2.74,324.478,332.852,
        341.16,347.178,348.064; 2.76,324.803,333.402,341.516,347.601,348.2; 2.78,
        325.135,333.892,341.959,347.857,348.384; 2.8,325.49,334.282,342.441,348.026,
        348.572; 2.82,325.878,334.617,342.828,348.239,348.676; 2.84,326.276,334.952,
        343.066,348.534,348.753; 2.86,326.645,335.282,343.269,348.81,348.864; 2.88,
        327.009,335.59,343.542,348.996,348.963; 2.9,327.35,335.898,343.876,349.114,
        349.022; 2.92,327.656,336.232,344.191,349.245,349.046; 2.94,327.959,336.582,
        344.462,349.418,349.052; 2.96,328.276,336.922,344.708,349.619,349.049; 2.98,
        328.6,337.236,344.961,349.818,349.035; 3,328.918,337.524,345.233,349.992,
        349.013; 3.02,329.225,337.805,345.514,350.132,348.982; 3.04,329.526,338.098,
        345.775,350.25,348.943; 3.06,329.83,338.409,346,350.365,348.893; 3.08,330.14,
        338.718,346.203,350.485,348.829; 3.1,330.451,339.006,346.413,350.602,348.75;
        3.12,330.756,339.272,346.638,350.708,348.658; 3.14,331.053,339.533,346.865,
        350.807,348.554; 3.16,331.342,339.798,347.085,350.9,348.441; 3.18,331.621,
        340.065,347.288,350.983,348.311; 3.2,331.898,340.333,347.487,351.063,348.176;
        3.22,332.175,340.592,347.678,351.131,348.026; 3.24,332.451,340.85,347.868,
        351.197,347.872; 3.26,332.725,341.1,348.049,351.25,347.7; 3.28,332.998,341.349,
        348.23,351.303,347.527; 3.3,333.269,341.595,348.405,351.347,347.344; 3.32,
        333.539,341.837,348.576,351.387,347.153; 3.34,333.807,342.077,348.744,351.421,
        346.955; 3.36,334.073,342.313,348.908,351.449,346.749; 3.38,334.336,342.546,
        349.066,351.47,346.534; 3.4,334.598,342.776,349.22,351.485,346.311; 3.42,
        334.857,343.003,349.37,351.493,346.081; 3.44,335.114,343.227,349.516,351.497,
        345.843; 3.46,335.37,343.449,349.658,351.494,345.599; 3.48,335.624,343.668,
        349.796,351.486,345.349; 3.5,335.875,343.884,349.93,351.472,345.091; 3.52,
        336.125,344.097,350.059,351.452,344.826; 3.54,336.373,344.307,350.185,351.426,
        344.554; 3.56,336.618,344.514,350.306,351.394,344.275; 3.58,336.862,344.719,
        350.424,351.357,343.99; 3.6,337.106,344.922,350.538,351.314,343.701; 3.62,
        337.347,345.122,350.648,351.266,343.407; 3.64,337.587,345.32,350.754,351.213,
        343.106; 3.66,337.825,345.514,350.857,351.153,342.799; 3.68,338.062,345.707,
        350.955,351.088,342.485; 3.7,338.297,345.896,351.049,351.018,342.166; 3.72,
        338.53,346.083,351.14,350.942,341.841; 3.74,338.762,346.268,351.227,350.861,
        341.513; 3.76,338.994,346.451,351.311,350.775,341.182; 3.78,339.224,346.632,
        351.39,350.684,340.846; 3.8,339.452,346.81,351.466,350.587,340.505; 3.82,
        339.679,346.985,351.538,350.485,340.16; 3.84,339.905,347.158,351.607,350.378,
        339.81; 3.86,340.129,347.329,351.672,350.266,339.455; 3.88,340.352,347.498,
        351.733,350.148,339.095; 3.9,340.574,347.664,351.79,350.027,338.736; 3.92,
        340.795,347.828,351.844,349.9,338.372; 3.94,341.014,347.99,351.894,349.768,
        338.005; 3.96,341.232,348.149,351.94,349.631,337.634; 3.98,341.449,348.307,
        351.982,349.489,337.259; 4,341.664,348.461,352.021,349.342,336.881; 4.02,
        341.879,348.614,352.056,349.19,336.5; 4.04,342.092,348.764,352.088,349.035,
        336.119; 4.06,342.303,348.911,352.115,348.874,335.735; 4.08,342.513,349.056,
        352.138,348.708,335.349; 4.1,342.722,349.199,352.158,348.538,334.96; 4.12,
        342.93,349.339,352.174,348.363,334.568; 4.14,343.136,349.477,352.187,348.184,
        334.174; 4.16,343.341,349.612,352.195,348,333.78; 4.18,343.544,349.744,352.199,
        347.812,333.386; 4.2,343.745,349.874,352.199,347.62,332.99; 4.22,343.946,
        350.001,352.196,347.424,332.593; 4.24,344.144,350.126,352.188,347.223,332.194;
        4.26,344.342,350.248,352.177,347.018,331.793; 4.28,344.538,350.367,352.162,
        346.808,331.392; 4.3,344.732,350.484,352.143,346.596,330.992; 4.32,344.925,
        350.599,352.121,346.38,330.592; 4.34,345.116,350.711,352.095,346.161,330.192;
        4.36,345.306,350.82,352.065,345.937,329.791; 4.38,345.495,350.926,352.032,
        345.71,329.39; 4.4,345.682,351.031,351.994,345.479,328.988; 4.42,345.868,
        351.132,351.953,345.244,328.586; 4.44,346.052,351.231,351.909,345.007,328.185;
        4.46,346.235,351.327,351.86,344.765,327.783; 4.48,346.416,351.421,351.808,
        344.521,327.382; 4.5,346.596,351.512,351.752,344.273,326.981; 4.52,346.774,
        351.6,351.693,344.021,326.58; 4.54,346.951,351.686,351.63,343.766,326.179;
        4.56,347.127,351.769,351.563,343.509,325.779; 4.58,347.3,351.849,351.492,
        343.249,325.382; 4.6,347.472,351.927,351.418,342.986,324.986; 4.62,347.642,
        352.001,351.34,342.72,324.591; 4.64,347.81,352.073,351.258,342.452,324.198;
        4.66,347.977,352.142,351.173,342.18,323.805; 4.68,348.143,352.208,351.084,
        341.905,323.412; 4.7,348.306,352.271,350.991,341.629,323.024; 4.72,348.466,
        352.33,350.894,341.35,322.637; 4.74,348.625,352.386,350.794,341.069,322.253;
        4.76,348.782,352.44,350.689,340.786,321.87; 4.78,348.936,352.49,350.581,
        340.499,321.489; 4.8,349.089,352.537,350.469,340.211,321.11; 4.82,349.24,
        352.581,350.354,339.92,320.732; 4.84,349.389,352.622,350.236,339.63,320.36;
        4.86,349.537,352.66,350.115,339.338,319.991; 4.88,349.682,352.695,349.991,
        339.045,319.625; 4.9,349.825,352.728,349.863,338.75,319.261; 4.92,349.966,
        352.757,349.732,338.453,318.9; 4.94,350.106,352.784,349.598,338.155,318.542;
        4.96,350.243,352.807,349.46,337.856,318.187; 4.98,350.379,352.828,349.32,
        337.555,317.833; 5,350.512,352.845,349.176,337.254,317.482; 5.02,350.643,
        352.86,349.029,336.951,317.134; 5.04,350.773,352.871,348.879,336.646,316.788;
        5.06,350.9,352.88,348.726,336.341,316.444; 5.08,351.025,352.886,348.57,336.034,
        316.104; 5.1,351.148,352.888,348.41,335.726,315.765; 5.12,351.268,352.887,
        348.248,335.418,315.429; 5.14,351.386,352.883,348.083,335.109,315.095; 5.16,
        351.502,352.875,347.914,334.8,314.764; 5.18,351.615,352.865,347.743,334.489,
        314.435; 5.2,351.726,352.851,347.568,334.177,314.108; 5.22,351.835,352.834,
        347.39,333.865,313.784; 5.24,351.942,352.814,347.209,333.552,313.463; 5.26,
        352.045,352.791,347.026,333.239,313.145; 5.28,352.146,352.764,346.84,332.926,
        312.831; 5.3,352.245,352.733,346.65,332.613,312.521; 5.32,352.34,352.699,
        346.459,332.299,312.215; 5.34,352.434,352.663,346.265,331.987,311.912; 5.36,
        352.525,352.623,346.069,331.675,311.612; 5.38,352.613,352.581,345.871,331.363,
        311.316; 5.4,352.699,352.535,345.671,331.052,311.024; 5.42,352.783,352.487,
        345.468,330.741,310.735; 5.44,352.864,352.436,345.263,330.431,310.449; 5.46,
        352.943,352.381,345.056,330.121,310.167; 5.48,353.019,352.324,344.848,329.811,
        309.887; 5.5,353.093,352.264,344.637,329.502,309.61; 5.52,353.164,352.201,
        344.424,329.194,309.336; 5.54,353.232,352.135,344.209,328.886,309.065; 5.56,
        353.298,352.066,343.992,328.578,308.798; 5.58,353.362,351.994,343.773,328.271,
        308.533; 5.6,353.422,351.919,343.552,327.965,308.272; 5.62,353.48,351.841,
        343.33,327.66,308.013; 5.64,353.535,351.76,343.105,327.356,307.758; 5.66,
        353.588,351.676,342.879,327.052,307.506; 5.68,353.638,351.589,342.651,326.75,
        307.258; 5.7,353.686,351.5,342.421,326.448,307.012; 5.72,353.731,351.408,
        342.191,326.148,306.771; 5.74,353.774,351.313,341.959,325.85,306.532; 5.76,
        353.814,351.216,341.726,325.553,306.297; 5.78,353.852,351.116,341.492,325.257,
        306.065; 5.8,353.887,351.014,341.256,324.962,305.837; 5.82,353.92,350.909,
        341.019,324.669,305.611; 5.84,353.95,350.801,340.782,324.377,305.388; 5.86,
        353.977,350.691,340.543,324.087,305.167; 5.88,354.001,350.579,340.303,323.798,
        304.95; 5.9,354.023,350.464,340.062,323.51,304.735; 5.92,354.042,350.346,
        339.82,323.224,304.524; 5.94,354.058,350.226,339.577,322.939,304.314; 5.96,
        354.072,350.103,339.333,322.656,304.108; 5.98,354.082,349.978,339.089,322.374,
        303.904; 6,354.09,349.85,338.843,322.094,303.703; 6.02,354.095,349.719,338.597,
        321.815,303.504; 6.04,354.097,349.586,338.349,321.537,303.309; 6.06,354.097,
        349.451,338.101,321.262,303.115; 6.08,354.094,349.314,337.853,320.988,302.925;
        6.1,354.088,349.174,337.603,320.715,302.737; 6.12,354.079,349.031,337.353,
        320.444,302.552; 6.14,354.068,348.886,337.102,320.175,302.37; 6.16,354.054,
        348.74,336.851,319.907,302.19; 6.18,354.038,348.592,336.601,319.642,302.013;
        6.2,354.02,348.442,336.35,319.379,301.838; 6.22,353.999,348.29,336.1,319.118,
        301.666; 6.24,353.976,348.136,335.849,318.858,301.497; 6.26,353.95,347.98,
        335.597,318.601,301.33; 6.28,353.922,347.822,335.346,318.345,301.166; 6.3,
        353.891,347.662,335.094,318.091,301.005; 6.32,353.858,347.501,334.843,317.839,
        300.846; 6.34,353.822,347.338,334.592,317.589,300.688; 6.36,353.783,347.173,
        334.34,317.341,300.533; 6.38,353.742,347.006,334.089,317.095,300.38; 6.4,
        353.698,346.838,333.838,316.85,300.23; 6.42,353.651,346.667,333.587,316.608,
        300.082; 6.44,353.602,346.495,333.336,316.368,299.936; 6.46,353.551,346.321,
        333.085,316.129,299.793; 6.48,353.497,346.146,332.835,315.892,299.651; 6.5,
        353.44,345.97,332.585,315.657,299.511; 6.52,353.381,345.792,332.335,315.424,
        299.373; 6.54,353.32,345.612,332.085,315.193,299.237; 6.56,353.256,345.43,
        331.835,314.964,299.104; 6.58,353.19,345.247,331.586,314.736,298.972; 6.6,
        353.121,345.062,331.337,314.511,298.843; 6.62,353.05,344.877,331.089,314.288,
        298.715; 6.64,352.978,344.691,330.842,314.066,298.59; 6.66,352.903,344.504,
        330.596,313.847,298.467; 6.68,352.827,344.316,330.35,313.63,298.345; 6.7,
        352.748,344.126,330.104,313.415,298.226; 6.72,352.667,343.935,329.859,313.202,
        298.109; 6.74,352.584,343.743,329.615,312.99,297.994; 6.76,352.499,343.55,
        329.371,312.781,297.88; 6.78,352.411,343.356,329.129,312.573,297.768; 6.8,
        352.321,343.161,328.887,312.368,297.657; 6.82,352.229,342.966,328.646,312.164,
        297.549; 6.84,352.135,342.769,328.405,311.963,297.442; 6.86,352.039,342.571,
        328.166,311.763,297.337; 6.88,351.94,342.372,327.927,311.565,297.234; 6.9,
        351.84,342.172,327.688,311.369,297.132; 6.92,351.737,341.972,327.451,311.175,
        297.032; 6.94,351.632,341.771,327.215,310.983,296.933; 6.96,351.526,341.569,
        326.98,310.792,296.836; 6.98,351.417,341.366,326.745,310.604,296.74; 7,351.306,
        341.163,326.511,310.417,296.646; 7.02,351.192,340.958,326.278,310.232,296.554;
        7.04,351.077,340.753,326.046,310.049,296.463; 7.06,350.961,340.548,325.816,
        309.867,296.385; 7.08,350.844,340.342,325.586,309.686,296.313; 7.1,350.725,
        340.137,325.357,309.507,296.248; 7.12,350.604,339.931,325.13,309.33,296.189;
        7.14,350.483,339.724,324.904,309.153,296.138; 7.16,350.36,339.518,324.679,
        308.978,296.094; 7.18,350.236,339.311,324.455,308.804,296.06; 7.2,350.109,
        339.104,324.232,308.633,296.021; 7.22,349.981,338.896,324.01,308.463,295.982;
        7.24,349.85,338.688,323.789,308.294,295.947; 7.26,349.718,338.48,323.57,
        308.128,295.914; 7.28,349.585,338.272,323.352,307.963,295.883; 7.3,349.45,
        338.064,323.135,307.799,295.854; 7.32,349.313,337.856,322.919,307.637,295.826;
        7.34,349.174,337.648,322.704,307.477,295.798; 7.36,349.035,337.439,322.49,
        307.319,295.77; 7.38,348.893,337.23,322.278,307.162,295.742; 7.4,348.751,
        337.021,322.066,307.007,295.716; 7.42,348.607,336.811,321.855,306.854,295.69;
        7.44,348.461,336.602,321.645,306.702,295.665; 7.46,348.314,336.392,321.437,
        306.552,295.641; 7.48,348.165,336.182,321.229,306.403,295.618; 7.5,348.016,
        335.972,321.023,306.256,295.594; 7.52,347.865,335.762,320.817,306.111,295.571;
        7.54,347.713,335.553,320.613,305.967,295.548; 7.56,347.559,335.343,320.41,
        305.826,295.526; 7.58,347.404,335.133,320.208,305.685,295.504; 7.6,347.248,
        334.923,320.008,305.547,295.483; 7.62,347.091,334.713,319.808,305.41,295.463;
        7.64,346.933,334.505,319.61,305.274,295.442; 7.66,346.775,334.296,319.413,
        305.14,295.421; 7.68,346.616,334.088,319.218,305.007,295.4; 7.7,346.455,
        333.88,319.024,304.876,295.38; 7.72,346.294,333.673,318.831,304.747,295.361;
        7.74,346.132,333.466,318.639,304.619,295.341; 7.76,345.968,333.259,318.449,
        304.493,295.322; 7.78,345.804,333.052,318.26,304.368,295.303; 7.8,345.639,
        332.846,318.072,304.245,295.285; 7.82,345.473,332.64,317.885,304.123,295.267;
        7.84,345.305,332.434,317.7,304.003,295.249; 7.86,345.137,332.228,317.516,
        303.884,295.231; 7.88,344.968,332.023,317.333,303.767,295.214; 7.9,344.798,
        331.818,317.152,303.652,295.197; 7.92,344.628,331.614,316.972,303.538,295.18;
        7.94,344.458,331.411,316.793,303.424,295.164; 7.96,344.287,331.209,316.616,
        303.312,295.148; 7.98,344.116,331.007,316.44,303.202,295.132; 8,343.944,
        330.805,316.265,303.093,295.116; 8.02,343.771,330.604,316.091,302.985,295.101;
        8.04,343.597,330.404,315.919,302.879,295.086; 8.06,343.423,330.204,315.748,
        302.774,295.071; 8.08,343.248,330.004,315.579,302.671,295.056; 8.1,343.072,
        329.805,315.41,302.569,295.042; 8.12,342.896,329.606,315.243,302.468,295.028;
        8.14,342.718,329.408,315.078,302.369,295.014; 8.16,342.54,329.21,314.913,
        302.272,295.001; 8.18,342.362,329.013,314.75,302.175,294.988; 8.2,342.183,
        328.816,314.589,302.081,294.975; 8.22,342.005,328.622,314.428,301.986,294.962;
        8.24,341.827,328.428,314.269,301.892,294.949; 8.26,341.649,328.234,314.111,
        301.8,294.936; 8.28,341.471,328.042,313.955,301.709,294.924; 8.3,341.292,
        327.85,313.8,301.619,294.912; 8.32,341.112,327.659,313.646,301.531,294.9;
        8.34,340.932,327.468,313.493,301.443,294.888; 8.36,340.752,327.278,313.342,
        301.357,294.877; 8.38,340.572,327.089,313.192,301.272,294.866; 8.4,340.391,
        326.9,313.044,301.189,294.855; 8.42,340.21,326.713,312.896,301.106,294.844;
        8.44,340.028,326.525,312.75,301.025,294.834; 8.46,339.846,326.339,312.606,
        300.945,294.823; 8.48,339.664,326.153,312.462,300.867,294.813; 8.5,339.482,
        325.969,312.32,300.789,294.803; 8.52,339.302,325.786,312.179,300.711,294.793;
        8.54,339.121,325.603,312.039,300.634,294.783; 8.56,338.94,325.422,311.9,
        300.559,294.774; 8.58,338.759,325.241,311.763,300.484,294.764; 8.6,338.578,
        325.061,311.627,300.411,294.755; 8.62,338.397,324.882,311.492,300.339,294.746;
        8.64,338.216,324.704,311.359,300.267,294.737; 8.66,338.034,324.527,311.227,
        300.197,294.728; 8.68,337.853,324.351,311.096,300.128,294.72; 8.7,337.672,
        324.175,310.966,300.06,294.711; 8.72,337.49,324,310.838,299.993,294.703;
        8.74,337.308,323.826,310.71,299.927,294.695; 8.76,337.127,323.653,310.584,
        299.862,294.687; 8.78,336.945,323.481,310.46,299.798,294.68; 8.8,336.764,
        323.31,310.336,299.735,294.672; 8.82,336.584,323.14,310.213,299.672,294.665;
        8.84,336.403,322.971,310.092,299.61,294.657; 8.86,336.223,322.803,309.972,
        299.549,294.65; 8.88,336.043,322.635,309.853,299.489,294.643; 8.9,335.863,
        322.469,309.735,299.43,294.636; 8.92,335.683,322.303,309.618,299.372,294.629;
        8.94,335.504,322.139,309.502,299.315,294.623; 8.96,335.325,321.975,309.388,
        299.258,294.616; 8.98,335.146,321.812,309.274,299.202,294.61; 9,334.967,
        321.651,309.162,299.147,294.604; 9.02,334.789,321.49,309.051,299.093,294.598;
        9.04,334.611,321.33,308.941,299.04,294.592; 9.06,334.433,321.171,308.832,
        298.987,294.586; 9.08,334.256,321.014,308.724,298.935,294.58; 9.1,334.079,
        320.857,308.618,298.884,294.574; 9.12,333.902,320.701,308.512,298.834,294.569;
        9.14,333.726,320.546,308.408,298.785,294.563; 9.16,333.55,320.392,308.304,
        298.736,294.558; 9.18,333.374,320.239,308.202,298.688,294.553; 9.2,333.199,
        320.087,308.101,298.64,294.548; 9.22,333.024,319.936,308.001,298.594,294.543;
        9.24,332.85,319.787,307.901,298.548,294.538; 9.26,332.676,319.638,307.803,
        298.502,294.533; 9.28,332.503,319.49,307.707,298.458,294.528; 9.3,332.33,
        319.343,307.611,298.414,294.524; 9.32,332.158,319.197,307.516,298.371,294.519;
        9.34,331.986,319.053,307.422,298.328,294.515; 9.36,331.815,318.909,307.329,
        298.286,294.511; 9.38,331.644,318.766,307.237,298.245,294.506; 9.4,331.473,
        318.623,307.146,298.204,294.502; 9.42,331.303,318.482,307.056,298.164,294.498;
        9.44,331.134,318.342,306.967,298.124,294.494; 9.46,330.965,318.203,306.879,
        298.085,294.49; 9.48,330.797,318.065,306.791,298.047,294.487; 9.5,330.629,
        317.928,306.705,298.009,294.483; 9.52,330.462,317.792,306.62,297.972,294.479;
        9.54,330.296,317.657,306.536,297.935,294.476; 9.56,330.13,317.523,306.452,
        297.899,294.472; 9.58,329.965,317.39,306.37,297.864,294.469; 9.6,329.8,317.257,
        306.288,297.829,294.465; 9.62,329.636,317.126,306.208,297.794,294.462; 9.64,
        329.473,316.997,306.128,297.76,294.459; 9.66,329.311,316.868,306.049,297.726,
        294.456; 9.68,329.149,316.74,305.971,297.693,294.453; 9.7,328.988,316.613,
        305.894,297.661,294.449; 9.72,328.828,316.487,305.818,297.629,294.446; 9.74,
        328.668,316.362,305.743,297.597,294.444; 9.76,328.509,316.238,305.668,297.566,
        294.441; 9.78,328.351,316.116,305.595,297.535,294.438; 9.8,328.194,315.994,
        305.522,297.504,294.435; 9.82,328.038,315.874,305.45,297.474,294.432; 9.84,
        327.882,315.754,305.379,297.445,294.429; 9.86,327.727,315.635,305.309,297.415,
        294.427; 9.88,327.573,315.518,305.24,297.387,294.424; 9.9,327.42,315.402,
        305.172,297.358,294.421; 9.92,327.268,315.286,305.104,297.33,294.419; 9.94,
        327.117,315.172,305.037,297.302,294.416; 9.96,326.966,315.059,304.971,297.275,
        294.414; 9.98,326.816,314.946,304.905,297.248,294.411; 10,326.667,314.835,
        304.841,297.221,294.409])
    annotation (Placement(transformation(extent={{50,80},{70,100}})));
  HeatAndMassTransfer.BoundaryConditions.Heat.HeatFlow heat2[pipe2.nV](each
      use_port=true)
    annotation (Placement(transformation(extent={{-56,-20},{-36,0}})));
  Modelica.Blocks.Sources.RealExpression realExpression[pipe2.nV](y=200*pipe2.geometry.dxs)
    annotation (Placement(transformation(extent={{-86,-20},{-66,0}})));
  Modelica.Blocks.Sources.CombiTimeTable timeTable_pipe2_p(smoothness=Modelica.Blocks.Types.Smoothness.ContinuousDerivative,
      table=[0,129873,128565,127670,126754,125350; 0.02,129873,128565,127670,126754,
        125350; 0.04,129873,128565,127670,126754,125350; 0.06,129873,128565,127670,
        126754,125350; 0.08,129873,128565,127670,126754,125350; 0.1,129873,128565,
        127670,126754,125350; 0.12,129873,128565,127670,126754,125350; 0.14,129873,
        128565,127670,126754,125350; 0.16,129873,128565,127670,126754,125350; 0.18,
        129873,128565,127670,126754,125350; 0.2,129873,128565,127670,126754,125350;
        0.22,129873,128565,127670,126754,125350; 0.24,129873,128565,127670,126754,
        125350; 0.26,129873,128565,127670,126754,125350; 0.28,129873,128565,127670,
        126754,125350; 0.3,129873,128565,127670,126754,125350; 0.32,129873,128565,
        127670,126754,125350; 0.34,129873,128565,127670,126754,125350; 0.36,129873,
        128565,127670,126754,125350; 0.38,129873,128565,127670,126754,125350; 0.4,
        129873,128565,127670,126754,125350; 0.42,129873,128565,127670,126754,125350;
        0.44,129873,128565,127670,126754,125350; 0.46,129873,128565,127670,126754,
        125350; 0.48,129873,128565,127670,126754,125350; 0.5,129873,128565,127670,
        126754,125350; 0.52,129873,128565,127670,126754,125350; 0.54,129873,128565,
        127670,126754,125350; 0.56,129873,128565,127670,126754,125350; 0.58,129873,
        128565,127670,126754,125350; 0.6,129873,128565,127670,126754,125350; 0.62,
        129873,128565,127670,126754,125350; 0.64,129873,128565,127670,126754,125350;
        0.66,129873,128565,127670,126754,125350; 0.68,129873,128565,127670,126754,
        125350; 0.7,129873,128565,127670,126754,125350; 0.72,129873,128565,127670,
        126754,125350; 0.74,129873,128565,127670,126754,125350; 0.76,129873,128565,
        127670,126754,125350; 0.78,129873,128565,127670,126754,125350; 0.8,129873,
        128565,127670,126754,125350; 0.82,129873,128565,127670,126754,125350; 0.84,
        129873,128565,127670,126754,125350; 0.86,129873,128565,127670,126754,125350;
        0.88,129873,128565,127670,126754,125350; 0.9,129873,128565,127670,126754,
        125350; 0.92,129873,128565,127670,126754,125350; 0.94,129873,128565,127670,
        126754,125350; 0.96,129873,128565,127670,126754,125350; 0.98,129873,128565,
        127670,126754,125350; 1,129873,128565,127670,126754,125350; 1.02,129873,
        128565,127670,126754,125350; 1.04,129873,128565,127670,126754,125350; 1.06,
        129873,128565,127670,126754,125350; 1.08,129873,128565,127670,126754,125350;
        1.1,129873,128565,127670,126754,125350; 1.12,129873,128565,127670,126754,
        125350; 1.14,129873,128565,127670,126754,125350; 1.16,129873,128565,127670,
        126754,125350; 1.18,129873,128565,127670,126754,125350; 1.2,129873,128565,
        127670,126754,125350; 1.22,129873,128565,127670,126754,125350; 1.24,129873,
        128565,127670,126754,125350; 1.26,129873,128565,127670,126754,125350; 1.28,
        129873,128565,127670,126754,125350; 1.3,129873,128565,127670,126754,125350;
        1.32,129873,128565,127670,126754,125350; 1.34,129873,128565,127670,126754,
        125350; 1.36,129873,128565,127670,126754,125350; 1.38,129873,128565,127670,
        126754,125350; 1.4,129873,128565,127670,126754,125350; 1.42,129873,128565,
        127670,126754,125350; 1.44,129873,128565,127670,126754,125350; 1.46,129873,
        128565,127670,126754,125350; 1.48,129873,128565,127670,126754,125350; 1.5,
        129873,128565,127670,126754,125350; 1.52,129873,128565,127670,126754,125350;
        1.54,129873,128565,127670,126754,125350; 1.56,129873,128565,127670,126754,
        125350; 1.58,129873,128565,127670,126754,125350; 1.6,129873,128565,127670,
        126754,125350; 1.62,129873,128565,127670,126754,125350; 1.64,129873,128565,
        127670,126754,125350; 1.66,129873,128565,127670,126754,125350; 1.68,129873,
        128565,127670,126754,125350; 1.7,129873,128565,127670,126754,125350; 1.72,
        129873,128565,127670,126754,125350; 1.74,129873,128565,127670,126754,125350;
        1.76,129873,128565,127670,126754,125350; 1.78,129873,128565,127670,126754,
        125350; 1.8,129873,128565,127670,126754,125350; 1.82,129873,128565,127670,
        126754,125350; 1.84,129873,128565,127670,126754,125350; 1.86,129873,128565,
        127670,126754,125350; 1.88,129873,128565,127670,126754,125350; 1.9,129873,
        128565,127670,126754,125350; 1.92,129873,128565,127670,126754,125350; 1.94,
        129873,128565,127670,126754,125350; 1.96,129873,128565,127670,126754,125350;
        1.98,129873,128565,127670,126754,125350; 2,129873,128565,127670,126754,125350;
        2.02,129873,128565,127670,126754,125350; 2.04,129873,128565,127670,126754,
        125350; 2.06,129873,128565,127670,126754,125351; 2.08,129873,128565,127670,
        126754,125374; 2.1,129873,128565,127670,126766,125636; 2.12,129873,128565,
        127678,126876,127227; 2.1317,129874,128567,127701,127132,129801; 2.14,129875,
        128571,127745,127527,132804; 2.16,129896,128614,128129,129935,142281; 2.16721,
        129924,128661,128464,131513,145114; 2.18,130058,128851,129555,135211,148276;
        2.2,130926,129786,133169,141451,149322; 2.22,134304,132569,138941,145182,
        149075; 2.24,141534,138766,144081,146382,149872; 2.24855,144141,142471,145548,
        146680,150180; 2.26,145656,147741,147044,147197,150697; 2.28,146519,155018,
        149725,148730,151497; 2.3,150366,157073,153686,151111,151463; 2.30952,152294,
        156462,155710,152500,151697; 2.32,153686,155370,157508,154198,152301; 2.34,
        154879,154104,158630,157563,154346; 2.36,155648,155093,157234,159936,157306;
        2.38,157828,157175,156243,159989,160043; 2.4,159812,158885,157431,158473,
        163140; 2.42,160398,160064,159579,158195,163945; 2.44,161464,161045,161142,
        160322,163708; 2.45435,162592,161813,161899,162629,164617; 2.46,163111,162147,
        162212,163535,165052; 2.48,164601,163551,163801,166087,166494; 2.48172,164686,
        163690,163977,166244,166596; 2.5,165174,165349,166120,167323,167344; 2.52,
        165129,167363,168333,167789,168070; 2.54,165364,168983,169555,168511,169541;
        2.56,166637,169598,169865,169913,170729; 2.58,166946,169321,170034,171341,
        171526; 2.6,166963,168712,170452,172016,172315; 2.62,167358,168497,170742,
        171959,173147; 2.64,168127,169016,170555,171703,173603; 2.66,168714,169876,
        170257,171563,173813; 2.68,169278,170439,170442,171565,173608; 2.7,169844,
        170595,171109,171723,173702; 2.72,170196,170751,171744,172190,173836; 2.74,
        170501,171178,172073,172870,174014; 2.76,170682,171740,172340,173421,174265;
        2.78,170871,172203,172756,173688,174613; 2.8,171093,172489,173250,173803,
        174983; 2.82,171366,172672,173590,173996,175215; 2.84,171653,172850,173674,
        174340,175407; 2.86,171886,173020,173697,174661,175675; 2.88,172112,173154,
        173841,174830,175936; 2.9,172295,173287,174095,174882,176137; 2.92,172416,
        173469,174320,174959,176290; 2.94,172532,173681,174474,175114,176426; 2.96,
        172672,173876,174587,175326,176560; 2.98,172822,174026,174715,175541,176690;
        3,172960,174134,174879,175719,176819; 3.02,173078,174228,175063,175842,176945;
        3.04,173185,174344,175217,175933,177071; 3.06,173296,174492,175310,176024,
        177190; 3.08,173418,174637,175367,176130,177299; 3.1,173540,174746,175439,
        176236,177397; 3.12,173653,174821,175542,176331,177484; 3.14,173751,174888,
        175654,176419,177564; 3.16,173834,174964,175756,176505,177642; 3.18,173901,
        175047,175838,176585,177718; 3.2,173965,175132,175914,176664,177794; 3.22,
        174027,175205,175982,176735,177862; 3.24,174089,175277,176050,176804,177929;
        3.26,174146,175337,176110,176864,177986; 3.28,174204,175397,176169,176924,
        178042; 3.3,174257,175453,176224,176978,178094; 3.32,174309,175505,176276,
        177029,178142; 3.34,174357,175553,176324,177076,178187; 3.36,174403,175598,
        176369,177120,178229; 3.38,174445,175640,176411,177161,178267; 3.4,174483,
        175678,176449,177198,178303; 3.42,174519,175713,176484,177231,178335; 3.44,
        174552,175746,176516,177263,178366; 3.46,174582,175777,176547,177293,178395;
        3.48,174610,175806,176575,177321,178422; 3.5,174636,175832,176601,177347,
        178447; 3.52,174659,175855,176625,177370,178469; 3.54,174679,175876,176646,
        177391,178490; 3.56,174697,175895,176664,177409,178508; 3.58,174712,175911,
        176681,177426,178525; 3.6,174728,175927,176697,177442,178541; 3.62,174742,
        175942,176711,177457,178555; 3.64,174754,175954,176724,177469,178568; 3.66,
        174764,175965,176735,177480,178579; 3.68,174772,175973,176744,177489,178588;
        3.7,174778,175980,176751,177496,178596; 3.72,174782,175985,176756,177502,
        178601; 3.74,174787,175990,176761,177507,178607; 3.76,174791,175995,176766,
        177512,178613; 3.78,174794,175998,176770,177516,178618; 3.8,174796,176001,
        176772,177519,178622; 3.82,174797,176002,176774,177521,178624; 3.84,174796,
        176002,176774,177522,178626; 3.86,174795,176001,176773,177522,178627; 3.88,
        174792,175999,176772,177521,178627; 3.9,174791,175997,176771,177520,178627;
        3.92,174788,175995,176769,177519,178627; 3.94,174785,175993,176767,177517,
        178627; 3.96,174781,175989,176763,177514,178625; 3.98,174777,175985,176760,
        177511,178623; 4,174772,175980,176755,177507,178621; 4.02,174766,175975,
        176750,177503,178618; 4.04,174761,175970,176745,177498,178614; 4.06,174755,
        175964,176740,177493,178609; 4.08,174749,175958,176734,177487,178604; 4.1,
        174742,175952,176728,177481,178598; 4.12,174734,175945,176721,177474,178592;
        4.14,174727,175937,176713,177467,178585; 4.16,174719,175929,176706,177460,
        178578; 4.18,174710,175921,176698,177452,178571; 4.2,174701,175912,176689,
        177444,178563; 4.22,174692,175903,176680,177435,178555; 4.24,174683,175894,
        176671,177426,178546; 4.26,174673,175884,176661,177416,178537; 4.28,174662,
        175873,176651,177406,178528; 4.3,174652,175864,176641,177397,178520; 4.32,
        174642,175854,176632,177389,178514; 4.34,174632,175844,176623,177380,178507;
        4.36,174622,175834,176613,177372,178501; 4.38,174612,175824,176604,177363,
        178495; 4.4,174602,175814,176594,177355,178490; 4.42,174591,175804,176585,
        177346,178484; 4.44,174581,175794,176575,177338,178479; 4.46,174571,175785,
        176567,177331,178474; 4.48,174562,175775,176558,177323,178470; 4.5,174552,
        175766,176549,177316,178465; 4.52,174542,175757,176541,177309,178461; 4.54,
        174533,175748,176533,177303,178457; 4.56,174524,175740,176525,177296,178452;
        4.58,174515,175732,176517,177288,178446; 4.6,174507,175723,176510,177281,
        178439; 4.62,174498,175715,176502,177274,178432; 4.64,174490,175707,176494,
        177266,178424; 4.66,174482,175700,176487,177259,178416; 4.68,174474,175692,
        176480,177252,178407; 4.7,174465,175684,176471,177244,178399; 4.72,174456,
        175675,176463,177235,178390; 4.74,174447,175666,176454,177226,178382; 4.76,
        174438,175657,176445,177217,178373; 4.78,174428,175648,176435,177208,178363;
        4.8,174419,175638,176426,177198,178354; 4.82,174409,175629,176416,177188,
        178344; 4.84,174400,175620,176408,177181,178339; 4.86,174392,175612,176400,
        177174,178335; 4.88,174384,175604,176393,177168,178332; 4.9,174375,175596,
        176385,177163,178330; 4.92,174367,175588,176379,177157,178329; 4.94,174359,
        175580,176372,177153,178330; 4.96,174352,175573,176366,177148,178330; 4.98,
        174345,175566,176360,177144,178327; 5,174338,175560,176354,177139,178325;
        5.02,174331,175554,176349,177135,178322; 5.04,174325,175548,176344,177131,
        178319; 5.06,174319,175543,176339,177127,178316; 5.08,174314,175538,176335,
        177124,178313; 5.1,174308,175533,176330,177119,178309; 5.12,174302,175527,
        176325,177115,178304; 5.14,174296,175522,176319,177109,178299; 5.16,174290,
        175516,176314,177104,178293; 5.18,174284,175511,176309,177099,178287; 5.2,
        174278,175505,176303,177093,178280; 5.22,174273,175500,176298,177087,178273;
        5.24,174267,175494,176292,177081,178267; 5.26,174261,175488,176286,177075,
        178260; 5.28,174254,175481,176279,177068,178254; 5.3,174247,175474,176272,
        177062,178249; 5.32,174240,175467,176265,177055,178244; 5.34,174233,175460,
        176259,177049,178240; 5.36,174227,175454,176253,177044,178237; 5.38,174220,
        175447,176247,177040,178235; 5.4,174214,175442,176242,177036,178233; 5.42,
        174208,175436,176237,177032,178233; 5.44,174203,175430,176232,177029,178233;
        5.46,174197,175425,176228,177027,178234; 5.48,174192,175420,176224,177023,
        178231; 5.5,174187,175415,176219,177020,178228; 5.52,174182,175411,176215,
        177016,178225; 5.54,174177,175407,176212,177013,178222; 5.56,174172,175402,
        176208,177010,178218; 5.58,174167,175398,176204,177007,178213; 5.6,174163,
        175394,176200,177003,178210; 5.62,174158,175390,176196,176999,178206; 5.64,
        174153,175385,176192,176995,178202; 5.66,174148,175381,176188,176991,178198;
        5.68,174144,175377,176184,176987,178194; 5.7,174140,175373,176180,176983,
        178190; 5.72,174136,175369,176177,176980,178189; 5.74,174133,175366,176174,
        176978,178189; 5.76,174131,175363,176171,176976,178189; 5.78,174129,175360,
        176169,176975,178190; 5.8,174127,175358,176167,176974,178191; 5.82,174125,
        175356,176165,176973,178192; 5.84,174123,175354,176163,176972,178192; 5.86,
        174122,175353,176162,176972,178193; 5.88,174120,175351,176161,176971,178193;
        5.9,174118,175350,176161,176971,178193; 5.92,174117,175349,176160,176971,
        178193; 5.94,174115,175348,176160,176971,178192; 5.96,174113,175347,176159,
        176970,178192; 5.98,174111,175345,176158,176970,178190; 6,174109,175344,
        176157,176969,178189; 6.02,174106,175342,176156,176968,178187; 6.04,174104,
        175341,176155,176967,178186; 6.06,174102,175339,176153,176965,178184; 6.08,
        174100,175337,176151,176964,178183; 6.1,174097,175335,176150,176962,178181;
        6.12,174095,175333,176148,176961,178180; 6.14,174092,175331,176145,176959,
        178178; 6.16,174090,175328,176143,176957,178177; 6.18,174089,175327,176142,
        176956,178177; 6.2,174089,175326,176142,176956,178177; 6.22,174088,175325,
        176141,176956,178178; 6.24,174088,175325,176141,176956,178179; 6.26,174088,
        175325,176140,176956,178180; 6.28,174089,175325,176140,176957,178182; 6.3,
        174090,175325,176141,176957,178184; 6.32,174091,175325,176141,176958,178186;
        6.34,174091,175325,176142,176959,178187; 6.36,174091,175326,176142,176960,
        178189; 6.38,174091,175326,176143,176961,178190; 6.4,174092,175327,176144,
        176962,178191; 6.42,174092,175328,176145,176964,178193; 6.44,174092,175328,
        176146,176965,178194; 6.46,174092,175329,176148,176967,178196; 6.48,174092,
        175330,176149,176968,178197; 6.5,174092,175330,176149,176969,178198; 6.52,
        174092,175331,176150,176970,178199; 6.54,174092,175331,176151,176971,178199;
        6.56,174092,175332,176152,176972,178200; 6.58,174092,175332,176153,176973,
        178201; 6.6,174092,175333,176154,176974,178201; 6.62,174092,175334,176155,
        176976,178203; 6.64,174094,175335,176156,176977,178204; 6.66,174096,175337,
        176158,176979,178206; 6.68,174098,175339,176160,176981,178209; 6.7,174101,
        175341,176162,176984,178211; 6.72,174103,175343,176164,176986,178214; 6.74,
        174107,175346,176167,176988,178217; 6.76,174110,175348,176169,176991,178219;
        6.78,174112,175350,176171,176993,178222; 6.8,174114,175353,176174,176996,
        178225; 6.82,174117,175355,176176,176998,178227; 6.84,174119,175357,176179,
        177001,178230; 6.86,174122,175360,176181,177004,178233; 6.88,174124,175362,
        176184,177007,178236; 6.9,174127,175365,176187,177010,178239; 6.92,174128,
        175367,176189,177012,178241; 6.94,174130,175369,176192,177015,178244; 6.96,
        174132,175372,176194,177017,178246; 6.98,174133,175374,176197,177020,178249;
        7,174135,175376,176199,177023,178251; 7.02,174136,175378,176202,177025,178253;
        7.04,174137,175380,176204,177028,178256; 7.06,174140,175383,176207,177031,
        178260; 7.08,174143,175386,176210,177035,178264; 7.1,174147,175389,176214,
        177039,178269; 7.12,174151,175393,176218,177043,178275; 7.14,174157,175398,
        176222,177047,178282; 7.16,174163,175402,176227,177052,178289; 7.18,174170,
        175408,176232,177058,178298; 7.2,174176,175413,176237,177063,178305; 7.22,
        174181,175418,176242,177068,178311; 7.24,174187,175423,176247,177074,178317;
        7.26,174192,175429,176253,177080,178322; 7.28,174197,175435,176259,177086,
        178327; 7.3,174201,175441,176266,177092,178331; 7.32,174206,175447,176273,
        177099,178335; 7.34,174210,175453,176279,177105,178339; 7.36,174214,175458,
        176284,177110,178344; 7.38,174218,175463,176289,177115,178348; 7.4,174223,
        175468,176294,177120,178352; 7.42,174227,175472,176299,177125,178357; 7.44,
        174231,175477,176304,177129,178361; 7.46,174234,175481,176308,177134,178365;
        7.48,174238,175485,176313,177138,178368; 7.5,174242,175489,176317,177142,
        178372; 7.52,174245,175493,176321,177146,178376; 7.54,174249,175496,176324,
        177149,178379; 7.56,174252,175500,176328,177153,178383; 7.58,174255,175503,
        176331,177156,178386; 7.6,174258,175506,176334,177159,178389; 7.62,174262,
        175509,176337,177162,178392; 7.64,174265,175512,176340,177165,178395; 7.66,
        174268,175515,176343,177168,178398; 7.68,174271,175518,176346,177171,178401;
        7.7,174274,175521,176349,177174,178404; 7.72,174276,175524,176352,177177,
        178407; 7.74,174279,175527,176355,177180,178410; 7.76,174282,175530,176358,
        177183,178413; 7.78,174285,175532,176360,177185,178415; 7.8,174287,175535,
        176363,177188,178418; 7.82,174290,175538,176366,177191,178420; 7.84,174292,
        175540,176368,177193,178423; 7.86,174295,175543,176371,177196,178425; 7.88,
        174297,175545,176373,177198,178427; 7.9,174299,175547,176376,177200,178429;
        7.92,174302,175550,176378,177203,178431; 7.94,174304,175552,176381,177205,
        178434; 7.96,174307,175555,176383,177208,178436; 7.98,174309,175557,176386,
        177210,178438; 8,174311,175560,176388,177213,178441; 8.02,174314,175562,
        176391,177215,178443; 8.04,174316,175565,176393,177217,178445; 8.06,174318,
        175567,176396,177220,178447; 8.08,174321,175569,176398,177222,178449; 8.1,
        174323,175572,176400,177224,178451; 8.12,174325,175574,176403,177226,178453;
        8.14,174327,175576,176405,177229,178455; 8.16,174329,175579,176407,177231,
        178457; 8.18,174331,175581,176410,177233,178459; 8.2,174334,175583,176412,
        177235,178461; 8.22,174336,175585,176414,177237,178463; 8.24,174338,175588,
        176417,177240,178465; 8.26,174340,175590,176419,177242,178467; 8.28,174343,
        175593,176421,177244,178469; 8.3,174345,175595,176424,177247,178471; 8.32,
        174347,175597,176426,177249,178473; 8.34,174350,175600,176428,177251,178475;
        8.36,174352,175602,176431,177253,178477; 8.38,174354,175604,176433,177256,
        178479; 8.4,174357,175607,176436,177258,178481; 8.42,174359,175609,176438,
        177260,178483; 8.44,174361,175612,176440,177262,178485; 8.46,174363,175614,
        176443,177265,178487; 8.48,174366,175616,176445,177267,178489; 8.5,174368,
        175619,176447,177269,178491; 8.52,174371,175621,176450,177271,178493; 8.54,
        174373,175624,176452,177274,178495; 8.56,174375,175626,176455,177276,178497;
        8.58,174378,175629,176457,177278,178499; 8.6,174380,175631,176460,177281,
        178501; 8.62,174383,175634,176462,177283,178504; 8.64,174385,175636,176465,
        177286,178506; 8.66,174388,175639,176467,177288,178508; 8.68,174390,175641,
        176470,177290,178510; 8.7,174393,175644,176472,177293,178512; 8.72,174395,
        175646,176475,177295,178514; 8.74,174398,175649,176477,177297,178516; 8.76,
        174400,175651,176480,177300,178519; 8.78,174403,175654,176482,177302,178521;
        8.8,174405,175656,176485,177305,178523; 8.82,174408,175659,176487,177307,
        178525; 8.84,174410,175662,176490,177310,178527; 8.86,174413,175664,176493,
        177312,178529; 8.88,174415,175667,176495,177314,178532; 8.9,174418,175670,
        176498,177317,178534; 8.92,174421,175672,176500,177319,178536; 8.94,174423,
        175675,176503,177322,178538; 8.96,174426,175677,176506,177324,178540; 8.98,
        174428,175680,176508,177327,178543; 9,174431,175683,176511,177329,178545;
        9.02,174434,175685,176513,177332,178547; 9.04,174436,175688,176516,177334,
        178549; 9.06,174439,175691,176519,177337,178552; 9.08,174442,175693,176521,
        177339,178554; 9.1,174444,175696,176524,177342,178556; 9.12,174447,175699,
        176527,177344,178558; 9.14,174450,175702,176529,177347,178561; 9.16,174452,
        175704,176532,177349,178563; 9.18,174455,175707,176535,177352,178565; 9.2,
        174458,175710,176537,177354,178568; 9.22,174461,175713,176540,177357,178570;
        9.24,174463,175715,176543,177360,178572; 9.26,174466,175718,176545,177362,
        178574; 9.28,174469,175721,176548,177365,178577; 9.3,174471,175724,176551,
        177367,178579; 9.32,174474,175726,176554,177370,178581; 9.34,174477,175729,
        176556,177372,178584; 9.36,174480,175732,176559,177375,178586; 9.38,174482,
        175735,176562,177378,178588; 9.4,174485,175737,176564,177380,178591; 9.42,
        174488,175740,176567,177383,178593; 9.44,174491,175743,176570,177385,178595;
        9.46,174494,175746,176573,177388,178598; 9.48,174496,175749,176575,177391,
        178600; 9.5,174499,175751,176578,177393,178602; 9.52,174502,175754,176581,
        177396,178605; 9.54,174505,175757,176584,177398,178607; 9.56,174507,175760,
        176586,177401,178609; 9.58,174510,175763,176589,177404,178612; 9.6,174513,
        175765,176592,177406,178614; 9.62,174516,175768,176595,177409,178617; 9.64,
        174519,175771,176597,177412,178619; 9.66,174521,175774,176600,177414,178621;
        9.68,174524,175777,176603,177417,178624; 9.7,174527,175780,176606,177420,
        178626; 9.72,174530,175782,176609,177422,178628; 9.74,174533,175785,176611,
        177425,178631; 9.76,174535,175788,176614,177427,178633; 9.78,174538,175791,
        176617,177430,178636; 9.8,174541,175794,176620,177433,178638; 9.82,174544,
        175797,176622,177435,178640; 9.84,174547,175799,176625,177438,178643; 9.86,
        174549,175802,176628,177441,178645; 9.88,174552,175805,176631,177443,178648;
        9.9,174555,175808,176634,177446,178650; 9.92,174558,175811,176636,177449,
        178652; 9.94,174561,175814,176639,177451,178655; 9.96,174563,175816,176642,
        177454,178657; 9.98,174566,175819,176645,177457,178660; 10,174569,175822,
        176647,177459,178662])
    annotation (Placement(transformation(extent={{20,80},{40,100}})));
equation
  connect(ramp1.y, boundary4.p_in) annotation (Line(
      points={{-19,80},{-8,80},{-8,72}},
      color={0,0,127},
      thickness=0.5));
  connect(boundary1.ports[1],pipe1. port_a) annotation (Line(
      points={{0,-70},{0,-70},{0,-60}},
      color={0,127,255},
      thickness=0.5));
  connect(pipe1.port_b,pipe3. port_a) annotation (Line(
      points={{0,-40},{0,-40},{0,-30},{20,-30},{20,-20}},
      color={0,127,255},
      thickness=0.5));
  connect(pipe3.port_b,pipe4. port_a) annotation (Line(
      points={{20,0},{20,0},{20,10},{0,10},{0,16},{0,20}},
      color={0,127,255},
      thickness=0.5));
  connect(pipe4.port_b, boundary4.ports[1]) annotation (Line(
      points={{0,40},{0,50}},
      color={0,127,255},
      thickness=0.5));
  connect(realExpression.y, heat2.Q_flow_ext) annotation (Line(points={{-65,-10},
          {-57.5,-10},{-50,-10}}, color={0,0,127}));
  connect(pipe2.port_a, pipe3.port_a) annotation (Line(
      points={{-20,-20},{-20,-30},{20,-30},{20,-20}},
      color={0,127,255},
      thickness=0.5));
  connect(pipe4.port_a, pipe2.port_b) annotation (Line(
      points={{0,20},{0,20},{0,10},{-20,10},{-20,0}},
      color={0,127,255},
      thickness=0.5));
  connect(heat2.port, pipe2.heatPorts[:, 1])
    annotation (Line(points={{-36,-10},{-25,-10}}, color={191,0,0}));
    annotation (
    Documentation(info="<html>
<p>This model demonstrates the use of distributed pipe models with dynamic energy, mass and momentum balances. At time=2s the pressure of boundary4 jumps, which causes a pressure wave and flow reversal. </p>
<p>Change system.momentumDynamics on the Assumptions tab of the system object from SteadyStateInitial to SteadyState, in order to assume a steady-state momentum balance. This is the default for all models of the library. </p>
<p>Note the static head caused by the elevation of the pipes. </p>
<p>Note the appropriate use of the Model Structure of the DynamicPipe models (Advanced tab). The default Model Structure is av_vb, i.e. volumes with a pressure state are exposed at both ports. In many cases this gives good numerical performance, avoiding algebraic loops in connections, e.g. if a pipe is connected to a valve or to a vessel with portsData configured. The price to pay is a high-index DAE if two pipes are connected or if a pipe is connected to a boundary with prescribed pressure. In such cases one might consider changing the Model Structure. </p>
<p>In the BranchingDynamicPipes example, {pipe1,pipe3,pipe4}.Model Structure are configured to a_v_b, while pipe2.Model Structure remains av_vb. This avoids a high-index DAE and overdetermined initial conditions. </p>
</html>"), experiment(StopTime=10),
    __Dymola_Commands(file(ensureSimulated=true)=
        "modelica://Modelica/Resources/Scripts/Dymola/Fluid/BranchingDynamicPipes/plotResults.mos"
        "plotResults"));
end BranchingDynamicPipes;
