within TRANSFORM.Fluid.Sensors.BaseClasses;
partial model PartialAbsoluteSensor
  "Partial component to model a sensor that measures a potential variable"

  extends TRANSFORM.Fluid.Interfaces.Records.Medium_fluid;

  parameter Boolean allowFlowReversal=true
    "= true to allow flow reversal, false restricts to design direction (port_a -> port_b)"
    annotation (Dialog(tab="Assumptions"), Evaluate=true);

  parameter Boolean showName=true "= false to hide component name"
    annotation (Dialog(tab="Visualization"));

  TRANSFORM.Fluid.Interfaces.FluidPort_Flow port(
    redeclare package Medium = Medium,
    m_flow(min=if allowFlowReversal then -Modelica.Constants.inf else 0),
    h_outflow(start=Medium.h_default))
    "Fluid connector"
    annotation (Placement(transformation(extent={{-10,-110},{10,-90}}, rotation=
           0), iconTransformation(extent={{-10,-110},{10,-90}})));
equation
  port.m_flow = 0;
  port.h_outflow = Medium.h_default;
  port.Xi_outflow = Medium.X_default[1:Medium.nXi];
  port.C_outflow = zeros(Medium.nC);
  annotation (Documentation(info="<html>
<p>
Partial component to model an <b>absolute sensor</b>. Can be used for pressure sensor models.
Use for other properties such as temperature or density is discouraged, because the enthalpy at the connector can have different meanings, depending on the connection topology. Use <code>PartialFlowSensor</code> instead.
as signal.
</p>
</html>"), Icon(graphics={
        Text(
          extent={{-149,112},{151,72}},
          lineColor={0,0,255},
          textString="%name",
          visible=DynamicSelect(true, showName))}));
end PartialAbsoluteSensor;
