within Physiolibrary;
package Icons "Icons for physiological models"
  //extends Modelica.Icons.IconsPackage;
  extends Modelica.Icons.Package;

  class Golem
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -98}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/golem.png")}));
  end Golem;

  class CardioVascular
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/csv.png")}));
  end CardioVascular;

  class Water
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/indexVoda.png")}));
  end Water;

  class Electrolytes
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/electrolytes.png")}));
  end Electrolytes;

  class Proteins
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-98, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/protein.png")}));
  end Proteins;

  class Gases
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/gases.png")}));
  end Gases;

  class NutrientsMetabolism
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/vyziva.png")}));
  end NutrientsMetabolism;

  class Heat
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/ohen.png")}));
  end Heat;

  class Hormones
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/hormony.png")}));
  end Hormones;

  class Nerves
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/nervyNeuron.png")}));
  end Nerves;

  class Setup
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/setup.png")}));
  end Setup;

  class Status
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-98, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/tissueFitness.png")}));
  end Status;

  class SkeletalMuscle
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-70, -80}, {40, 92}}, fileName = "modelica://Physiolibrary/Resources/Icons/sval.png")}));
  end SkeletalMuscle;

  class Bone
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics={  Rectangle(extent = {{-100, -100}, {100, 100}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, pattern = LinePattern.None), Bitmap(extent = {{-88, -84}, {52, 96}}, fileName = "modelica://Physiolibrary/Resources/Icons/bone.png")}));
  end Bone;

  class OtherTissue
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-74, -94}, {48, 60}}, fileName = "modelica://Physiolibrary/Resources/Icons/pojivovaTkan.png")}));
  end OtherTissue;

  class RespiratoryMuscle
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-66, -86}, {44, 86}}, fileName = "modelica://Physiolibrary/Resources/Icons/respiracniSvaly.png")}));
  end RespiratoryMuscle;

  class Fat
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-84, -68}, {38, 86}}, fileName = "modelica://Physiolibrary/Resources/Icons/tukovaBunka.png")}));
  end Fat;

  class Skin
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-74, -84}, {48, 56}}, fileName = "modelica://Physiolibrary/Resources/Icons/skin.png")}));
  end Skin;

  class Brain
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-78, -92}, {44, 62}}, fileName = "modelica://Physiolibrary/Resources/Icons/brain.png")}));
  end Brain;

  class GITract
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-80, -80}, {42, 74}}, fileName = "modelica://Physiolibrary/Resources/Icons/traviciTrakt.png")}));
  end GITract;

  class LeftHeart
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, -100}, {24, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/srdceLeva.png")}));
  end LeftHeart;

  class RightHeart
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-26, -100}, {92, 66}}, fileName = "modelica://Physiolibrary/Resources/Icons/srdceprava.png")}));
  end RightHeart;

  class Liver
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-84, -100}, {86, 34}}, fileName = "modelica://Physiolibrary/Resources/Icons/jatra.png")}));
  end Liver;

  class Kidney
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-92, -88}, {40, 86}}, fileName = "modelica://Physiolibrary/Resources/Icons/kidney.png")}));
  end Kidney;

  class Bladder
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Rectangle(extent = {{-100, -100}, {100, 100}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, pattern = LinePattern.None), Bitmap(extent = {{-92, -88}, {40, 86}}, fileName = "modelica://Physiolibrary/Resources/Icons/mocovyMechyr.png")}));
  end Bladder;

  class GILumen
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/traviciTrakt2.png")}));
  end GILumen;

  class ThyroidGland
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-92, -88}, {40, 86}}, fileName = "modelica://Physiolibrary/Resources/Icons/stitnaZlaza.png")}));
  end ThyroidGland;

  class Pancreas
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/pankreas.png")}));
  end Pancreas;

  class AdrenalGland
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/nadledviny.png")}));
  end AdrenalGland;

  class Lungs
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-70, -80}, {40, 92}}, fileName = "modelica://Physiolibrary/Resources/Icons/plice.png")}));
  end Lungs;

  class Tissues
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-46, 26}, {32, 98}}, fileName = "modelica://Physiolibrary/Resources/Icons/bone.png"), Bitmap(extent = {{-62, -92}, {50, -10}}, fileName = "modelica://Physiolibrary/Resources/Icons/skin.png"), Bitmap(extent = {{-38, -20}, {64, 90}}, fileName = "modelica://Physiolibrary/Resources/Icons/sval.png"), Bitmap(extent = {{-10, -56}, {102, 36}}, fileName = "modelica://Physiolibrary/Resources/Icons/traviciTrakt.png"), Text(extent = {{64, -66}, {94, -96}}, lineColor = {0, 0, 0}, textString = "..."), Bitmap(extent = {{-98, -30}, {-24, 36}}, fileName = "modelica://Physiolibrary/Resources/Icons/brain.png")}));
  end Tissues;

  class Peritoneum
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-70, -80}, {40, 92}}, fileName = "modelica://Physiolibrary/Resources/Icons/peritoneum.png")}));
  end Peritoneum;

  class Plasma
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-70, -80}, {40, 92}}, fileName = "modelica://Physiolibrary/Resources/Icons/plazma.png")}));
  end Plasma;

  class Hypophysis
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/hypofyza.png")}));
  end Hypophysis;

  class Heart
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/heartPict.png")}));
  end Heart;

  class SweatGland
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/potniZlaza.png")}));
  end SweatGland;

  class Cell
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/OsmothicCell.png")}));
  end Cell;

  package HeatLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -82}, {76, 44}}, fileName = "modelica://Physiolibrary/Resources/Icons/ohen.png")}));
  end HeatLib;

  package StatusLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, 40}, {72, -96}}, fileName = "modelica://Physiolibrary/Resources/Icons/tissueFitness.png")}));
  end StatusLib;

  package NervesLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, -96}, {72, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/nervyNeuron.png")}));
  end NervesLib;

  package NutrientsMetabolismLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-98, -100}, {80, 40}}, fileName = "modelica://Physiolibrary/Resources/Icons/vyziva.png")}));
  end NutrientsMetabolismLib;

  package OxygenLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, -98}, {78, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/O2.png")}));
  end OxygenLib;

  package ProteinsLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-98, -98}, {76, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/protein.png")}));
  end ProteinsLib;

  package SetupLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-94, -98}, {72, 44}}, fileName = "modelica://Physiolibrary/Resources/Icons/setup.png")}));
  end SetupLib;

  package CardioVascularLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, -100}, {76, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/csv.png")}));
  end CardioVascularLib;

  package WaterLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-90, -84}, {72, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/indexVoda.png")}));
  end WaterLib;

  package KidneyLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, -96}, {72, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/Kidney.png")}));
  end KidneyLib;

  package ElectrolytesLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-78, -94}, {64, 38}}, fileName = "modelica://Physiolibrary/Resources/Icons/electrolytes.png")}));
  end ElectrolytesLib;

  package GasesLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-88, -82}, {66, 34}}, fileName = "modelica://Physiolibrary/Resources/Icons/gases.png")}));
  end GasesLib;

  partial package GolemLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, -98}, {78, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/golem.png")}));
  end GolemLib;

  partial package BaseLib
    extends Modelica.Icons.Package;
  end BaseLib;

  package HormonesLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-88, -88}, {74, 30}}, fileName = "modelica://Physiolibrary/Resources/Icons/hormony.png")}));
  end HormonesLib;

  package AutonomicControlLib
    extends Modelica.Icons.Package;
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-96, -96}, {72, 42}}, fileName = "modelica://Physiolibrary/Resources/Icons/sympatetickeNervy.png")}));
  end AutonomicControlLib;

  partial class Resistor
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={  Rectangle(extent = {{-70, -30}, {70, 30}}, lineColor = {0, 0, 0}, fillColor = {241, 241, 241}, fillPattern = FillPattern.Solid), Line(points = {{-90, 0}, {-70, 0}}), Line(points = {{70, 0}, {90, 0}})}));
  end Resistor;

  class Lymph
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Lymph.png")}));
  end Lymph;

  class RespiratoryCenter
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/respiracniCentrum.png")}));
  end RespiratoryCenter;

  class Oxygen
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/O2.png")}));
  end Oxygen;

  class CarbonDioxide
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/prvkyCO2.png")}));
  end CarbonDioxide;

  class AcidBase
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/acidobaze.png")}));
  end AcidBase;

  class Ventilation
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/dychani.png")}));
  end Ventilation;

  class PeripheralChemoreceptors
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/baroreflex.png")}));
  end PeripheralChemoreceptors;

  class HeatCore
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, 100}, {100, -100}}, fileName = "modelica://Physiolibrary/Resources/Icons/torzo2.png")}));
  end HeatCore;

  class Glycogen
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Rectangle(extent = {{-100, -100}, {100, 100}}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid, pattern = LinePattern.None), Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/glykogen.png")}));
  end Glycogen;

  class Lipids
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/FattyAcid.png")}));
  end Lipids;

  class KetoAcids
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/KetoAcid.png")}));
  end KetoAcids;

  class Glucose
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/glucose.png")}));
  end Glucose;

  class Lactate
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Lactate.png")}));
  end Lactate;

  class AminoAcids
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/AminoAcid.png")}));
  end AminoAcids;

  class Urea
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Urea.png")}));
  end Urea;

  class MetabolismPart
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 120}}), graphics={  Bitmap(extent={{28,44},
              {98,120}},                                                                                                                         fileName = "modelica://Physiolibrary/Resources/Icons/ohen.png")}));
  end MetabolismPart;

  class CellularMetabolism
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/cellularMetabolism.png")}));
  end CellularMetabolism;

  class FemaleSex
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/hormonesFemaleSex.png")}));
  end FemaleSex;

  class Barroreceptor
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/baroreflex.png")}));
  end Barroreceptor;

  class NervusVagus
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/vagus.png")}));
  end NervusVagus;

  class SympatheticNerves
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/sympatetickeNervy.png")}));
  end SympatheticNerves;

  class PhysicalExercise
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/cviceni.png")}));
  end PhysicalExercise;

  class SinoatrialNode
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/SANode.png")}));
  end SinoatrialNode;

  block StatusNormal
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/siluetaNormal.png")}));
  end StatusNormal;

  block StatusConfused
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/siluetaZmateni.png")}));
  end StatusConfused;

  block StatusImpaired
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/siluetaVaznejsiStav.png")}));
  end StatusImpaired;

  block StatusNotBreathing
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/siluetaNedychaSam.png")}));
  end StatusNotBreathing;

  block StatusComatose
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/siluetaKoma.png")}));
  end StatusComatose;

  block StatusMayBeDead
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/siluetaSkoroMrtvy.png")}));
  end StatusMayBeDead;

  block StatusIsReallyDead
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/siluetaMrtvy.png")}));
  end StatusIsReallyDead;

  class SkeletalMuscleAcidity
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/kyselostVeSvalech.png")}));
  end SkeletalMuscleAcidity;

  class Sodium
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Na.png")}));
  end Sodium;

  class Potassium
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/K.png")}));
  end Potassium;

  class Phosphate
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/fosfat.png")}));
  end Phosphate;

  class Sulphate
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/sulfat02.png")}));
  end Sulphate;

  class Amonium
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/NH4.png")}));
  end Amonium;

  class Chloride
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Cl.png")}));
  end Chloride;

  class LungShunt
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/lungBloodFlow.png")}));
  end LungShunt;

  class Hydrostatics
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/pressureMeassure.png")}));
  end Hydrostatics;

  class UpperTorso
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/torzo1.png")}));
  end UpperTorso;

  class MiddleTorso
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/torzo2.png")}));
  end MiddleTorso;

  class LowerTorso
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/torzo3.png")}));
  end LowerTorso;

  class RedCells
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/cervenaKrvinka.png")}));
  end RedCells;

  class SystemicCirculation
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/krevniRecisteSiluetacloveka.png")}));
  end SystemicCirculation;

  class PulmonaryCirculation
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/krevniRecistePlice.png")}));
  end PulmonaryCirculation;

  class Blood
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/bloodProperties.png")}));
  end Blood;

  class BaseFactorIcon0
    annotation (
      Icon(graphics={  Rectangle(extent = {{-100, -40}, {100, 60}}, lineColor = {0, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Sphere), Text(extent = {{-76, -22}, {64, 44}}, lineColor = {0, 0, 0}, textString = "%name")}));
  end BaseFactorIcon0;

  partial class BaseFactorIcon
    Modelica.Blocks.Interfaces.RealInput yBase annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, 20})));
    Modelica.Blocks.Interfaces.RealOutput y annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, -40})));
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={  Rectangle(extent = {{-100, -20}, {100, 20}}, lineColor = {95, 95, 95}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Sphere), Text(extent = {{-90, -10}, {92, 10}}, textString = "%name", lineColor = {0, 0, 0})}));
  end BaseFactorIcon;

  partial class BaseFactorIcon2
    Modelica.Blocks.Interfaces.RealInput yBase annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, 60})));
    Modelica.Blocks.Interfaces.RealOutput y annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, -60})));
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={  Rectangle(extent = {{-100, -50}, {100, 50}}, lineColor = {0, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Sphere), Text(extent = {{-86, -36}, {100, 40}}, textString = "%name", lineColor = {0, 0, 0}, fillPattern = FillPattern.Sphere)}));
  end BaseFactorIcon2;

  partial class BaseFactorIcon3
    Modelica.Blocks.Interfaces.RealInput yBase annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, 20})));
    Modelica.Blocks.Interfaces.RealOutput y annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, -40})));
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={  Rectangle(extent = {{-100, -20}, {100, 20}}, lineColor = {0, 127, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Sphere), Text(extent = {{-90, -10}, {92, 10}}, textString = "%name", lineColor = {0, 0, 0})}));
  end BaseFactorIcon3;

  partial class BaseFactorIcon4
    Modelica.Blocks.Interfaces.RealInput yBase annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, 20})));
    Modelica.Blocks.Interfaces.RealOutput y annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, -40})));
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={  Rectangle(extent = {{-100, -20}, {100, 20}}, lineColor = {127, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Sphere), Text(extent = {{-90, -10}, {92, 10}}, textString = "%name", lineColor = {0, 0, 0})}));
  end BaseFactorIcon4;

  partial class BaseFactorIcon5
    Modelica.Blocks.Interfaces.RealInput yBase annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, 20})));
    Modelica.Blocks.Interfaces.RealOutput y annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, -40})));
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={  Rectangle(extent = {{-100, -20}, {100, 20}}, lineColor = {0, 0, 255}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Sphere), Text(extent = {{-90, -10}, {92, 10}}, textString = "%name", lineColor = {0, 0, 0})}));
  end BaseFactorIcon5;

  partial class BaseFactorIcon6
    Modelica.Blocks.Interfaces.RealInput yBase annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, 20})));
    Modelica.Blocks.Interfaces.RealOutput y annotation (
      Placement(transformation(extent = {{-20, -20}, {20, 20}}, rotation = 270, origin = {0, -40})));
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}, grid = {2, 2}), graphics={  Rectangle(extent = {{-100, -20}, {100, 20}}, lineColor = {0, 87, 87}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Sphere)}));
  end BaseFactorIcon6;

  partial class ConversionIcon "Base icon for conversion functions"
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics={  Rectangle(extent = {{-100, -100}, {100, 100}}, lineColor = {191, 0, 0}, fillColor = {255, 255, 255}, fillPattern = FillPattern.Solid), Line(points = {{-74, 0}, {30, 0}}, color = {191, 0, 0}), Polygon(points = {{80, 0}, {20, 20}, {20, -20}, {80, 0}}, lineColor = {191, 0, 0}, fillColor = {191, 0, 0}, fillPattern = FillPattern.Solid)}));
  end ConversionIcon;

  partial class Diffusion
    annotation (
      Icon(graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/diffusion.png")}));
  end Diffusion;

  class Substance
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Concentration.png")}));
  end Substance;

  class Speciation
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = true, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Speciation.png"), Text(extent = {{-182, -84}, {60, -118}}, lineColor = {0, 0, 255}, textString = "%name")}));
  end Speciation;

  class MolarFlowMeasure
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/molarFlowMeassure.png")}));
  end MolarFlowMeasure;

  class GasSolubility
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/GasSolubility.png")}));
  end GasSolubility;

  class Reabsorption
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/reabsorption.svg")}));
  end Reabsorption;

  class Reabsorption2
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/reabsorption.png")}));
  end Reabsorption2;

  class Dilution
    annotation (
      Icon(graphics={  Bitmap(extent = {{-100, -101}, {100, 101}}, fileName = "modelica://Physiolibrary/Resources/Icons/dilution.png", origin = {0, 33}, rotation = 270)}));
  end Dilution;

  partial class ElasticBalloon
    annotation (
      Icon(graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/elastic_vessel.svg")}));
  end ElasticBalloon;

  class BloodElasticCompartment
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/elastickyKompartment.png")}));
  end BloodElasticCompartment;

  class BloodSequesteredCompartment
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/sequerestedVolume.png")}));
  end BloodSequesteredCompartment;

  partial class HydraulicResistor
    annotation (
      Icon(graphics={  Bitmap(extent = {{-120, -42}, {120, 44}}, fileName = "modelica://Physiolibrary/Resources/Icons/resistor.svg")}));
  end HydraulicResistor;

  class FlowMeasure
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/flowMeassure.png")}));
  end FlowMeasure;

  class Membrane
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/membrane.png")}));
  end Membrane;

  class PressureMeasure
    annotation (
      Icon(graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/pressureMeassure.png")}));
  end PressureMeasure;

  class InternalElasticBalloon
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/elastic_membrane.svg")}));
  end InternalElasticBalloon;

  class Inertance
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/inertia.svg")}));
  end Inertance;

  class HydrostaticGradient
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {102, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/hydrostatic_column.svg")}));
  end HydrostaticGradient;

  class Radiator
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Radiator.png")}));
  end Radiator;

  class MichaelisMenten
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-80, -84}, {86, 26}}, fileName = "modelica://Physiolibrary/Resources/Icons/MichaelisMenten.png")}));
  end MichaelisMenten;

  class HeatAccumulation
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/HeatAccumulation.png")}));
  end HeatAccumulation;

  class OsmoticCell
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/OsmothicCell.png")}));
  end OsmoticCell;

  class IdealGas
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/IdealGas.png")}));
  end IdealGas;

  class PartialPressure
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/PartialPressure.png")}));
  end PartialPressure;

  class ConservationLaw
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Rectangle(extent = {{-100, -100}, {100, 100}}, fillColor = {170, 255, 213}, fillPattern = FillPattern.Solid, pattern = LinePattern.None), Polygon(points = {{-40, -60}, {-40, -20}, {-80, -40}, {-40, -60}}, pattern = LinePattern.None, fillColor = {0, 0, 0}, fillPattern = FillPattern.Solid, lineColor = {0, 0, 0}), Line(points = {{-80, 10}, {-80, -80}, {-80, -80}})}));
  end ConservationLaw;

  class Nephron
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Nefron.png")}));
  end Nephron;

  class Torso
    annotation (
      Icon(graphics={  Bitmap(extent = {{-28, 58}, {28, 98}}, fileName = "modelica://Physiolibrary/Resources/Icons/torzo1.png"), Bitmap(extent = {{-40, -24}, {40, 56}}, fileName = "modelica://Physiolibrary/Resources/Icons/torzo2.png"), Bitmap(extent = {{-40, -98}, {40, -18}}, fileName = "modelica://Physiolibrary/Resources/Icons/torzo3.png")}));
  end Torso;

  class PerfusionOD
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-160, -100}, {152, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/perfusion.png")}));
  end PerfusionOD;

  class PerfusionDO
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-160, -100}, {160, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/perfusion2.png")}));
  end PerfusionDO;

  class CollapsingVessel
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/kolaps.png")}));
  end CollapsingVessel;

  class PeripheralCirculation
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/krevniReciste.png")}));
  end PeripheralCirculation;

  class HeartVentricle
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/komoraSrdce.png")}));
  end HeartVentricle;

  class Population
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Populace.png")}));
  end Population;

  class FlowFiltration
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -74}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/flowFiltration.png")}));
  end FlowFiltration;

  class Microcirculation
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics={  Bitmap(extent = {{-100, -98}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/microcirculation.png")}));
  end Microcirculation;

  class IdealValve
    annotation (
      Icon(graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/ideal_valve.svg")}));
  end IdealValve;

  class Pump
    annotation (
      Icon(graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/pump.svg")}));
  end Pump;

  model Arteries
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-87.243, -87.3037}, {87.243, 87.3037}}, fileName = "modelica://Physiolibrary/Resources/Icons/Arteries.png", origin = {4.25124, 18.8661}, rotation = 75)}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Arteries;

  class Atrium
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Atrium.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Atrium;

  class Cardio
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Cardio.png"), Bitmap(extent = {{-50, -38}, {52, 62}}, fileName = "modelica://Physiolibrary/Resources/Icons/Cross.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Cardio;

  class ECMO
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/ECMO.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end ECMO;

  class Heart_detailed
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Heart_detailed.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Heart_detailed;

  class O2
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/O2.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end O2;

  class Screw
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Screw.png", origin = {2, -4}, rotation = 90)}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Screw;

  class Settings
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Settings.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Settings;

  class Valve
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Valve.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Valve;

  class Ventricle
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-100, -100}, {100, 100}}, fileName = "modelica://Physiolibrary/Resources/Icons/Ventricle.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Ventricle;

  class Vessels
    annotation (
      Icon(coordinateSystem(preserveAspectRatio = false), graphics={  Bitmap(extent = {{-130.465, -88.1195}, {130.465, 88.1195}}, origin = {0.99971, 8.9994}, rotation = -68, fileName = "modelica://Physiolibrary/Resources/Icons/Vessels.png")}),
      Diagram(coordinateSystem(preserveAspectRatio = false)));
  end Vessels;
  annotation (
    Documentation(revisions = ""));
end Icons;
