﻿within BuildSysPro.BoundaryConditions.Scenarios.DrawOff_Scenario;
model DHW_CollectiveHousing_PACTE
  "DHW draw-off scenario for collective housing - PACTE ECS"

 constant Real[1,6] STD_Coefficient_Private_Housing = [0.6,0.7,0.9,1.1,1.3,1.4];
 constant Real[1,6] STD_Coefficient_Social_Housing = [0.6,0.7,1,1.4,1.8,1.9];
 constant Real[1,7] Coefficient_Day = [0.96,0.94,0.98,0.96,0.97,0.98,1.21];
 constant Real[1,12] Coefficient_Month = [1.07,1.06,1.07,1.01,1.01,0.97,0.86,0.78,0.96,1.03,1.08,1.10];
 constant Real[7,24] Coefficient_Hour=[
 0.017,0.009,0.005,0.004,0.007,0.014,0.028,0.039,0.043,0.05,0.052,0.057,0.07,0.064,0.045,0.04,0.047,0.059,0.069,0.077,0.076,0.057,0.041,0.03;
 0.017,0.009,0.005,0.004,0.007,0.014,0.028,0.039,0.043,0.05,0.052,0.057,0.07,0.064,0.045,0.04,0.047,0.059,0.069,0.077,0.076,0.057,0.041,0.03;
 0.017,0.009,0.005,0.004,0.007,0.014,0.028,0.039,0.043,0.05,0.052,0.057,0.07,0.064,0.045,0.04,0.047,0.059,0.069,0.077,0.076,0.057,0.041,0.03;
 0.017,0.009,0.005,0.004,0.007,0.014,0.028,0.039,0.043,0.05,0.052,0.057,0.07,0.064,0.045,0.04,0.047,0.059,0.069,0.077,0.076,0.057,0.041,0.03;
 0.017,0.009,0.005,0.004,0.007,0.014,0.028,0.039,0.043,0.05,0.052,0.057,0.07,0.064,0.045,0.04,0.047,0.059,0.069,0.077,0.076,0.057,0.041,0.03;
 0.018,0.01,0.006,0.005,0.005,0.008,0.013,0.026,0.041,0.059,0.064,0.071,0.075,0.075,0.066,0.05,0.049,0.055,0.062,0.064,0.062,0.049,0.039,0.028;
 0.015,0.01,0.006,0.004,0.004,0.006,0.008,0.013,0.026,0.045,0.06,0.071,0.076,0.074,0.06,0.053,0.05,0.06,0.076,0.082,0.078,0.057,0.04,0.026];

Integer Hour=integer(BuildSysPro.Utilities.Time.Hour(1,time))+1;
Integer Day=integer(BuildSysPro.Utilities.Time.DayWeek(1,time))+1;
Integer Month=integer(BuildSysPro.Utilities.Time.MonthYear(1,time));

  Modelica.Units.SI.Volume Vm=125
    "average daily requirement at 40°C per standard housing (liters)";

public
  Modelica.Blocks.Interfaces.RealInput T_cold annotation (Placement(
        transformation(extent={{-120,50},{-80,90}}), iconTransformation(extent={
            {-120,50},{-80,90}})));
  Modelica.Blocks.Interfaces.RealInput T_hot annotation (Placement(
        transformation(extent={{-120,-82},{-80,-42}}), iconTransformation(
          extent={{-120,-62},{-80,-22}})));
  Modelica.Blocks.Interfaces.RealOutput drawoff_flow_rate(start=1e-10)
    "Draw-off flow rate (kg/s)" annotation (Placement(transformation(extent={{94,
            -10},{114,10}}), iconTransformation(extent={{94,-10},{114,10}})));

  parameter String Housing_type="Housing in the private sector" "Type of collective housing" annotation (choices(
        choice="Logements du parc privé", choice="Logements du parc social",  choice="Logements mixtes ou inconnus"));

parameter Real T1_number=1 "Number of housings type T1";
parameter Real T2_number=1 "Number of housings type T2";
parameter Real T3_number=1 "Number of housings type T3";
parameter Real T4_number=1 "Number of housings type T4";
parameter Real T5_number=1 "Number of housings type T5";
parameter Real T6_number=1 "Number of housings type T6 ou plus";
parameter Real Gain=1 "Gain at average consumption value of DHW at 40°C (125 l/day/housing standard) - 1,4 equals to 1 standard deviation";

 Real Standard_Housing_number "Number of standard housings ";

algorithm

 if Housing_type=="Private housing park" then
 Standard_Housing_number:=STD_Coefficient_Private_Housing[1,1]*T1_number+STD_Coefficient_Private_Housing[1,2]*T2_number+
 STD_Coefficient_Private_Housing[1,3]*T3_number+STD_Coefficient_Private_Housing[1,4]*T4_number+STD_Coefficient_Private_Housing[1,5]*T5_number+
 STD_Coefficient_Private_Housing[1,6]*T6_number;
 elseif Housing_type=="Social housing park" then
  Standard_Housing_number:=STD_Coefficient_Social_Housing[1,1]*T1_number+STD_Coefficient_Social_Housing[1,2]*T2_number+
 STD_Coefficient_Social_Housing[1,3]*T3_number+STD_Coefficient_Social_Housing[1,4]*T4_number+STD_Coefficient_Social_Housing[1,5]*T5_number+
 STD_Coefficient_Social_Housing[1,6]*T6_number;
 else
 Standard_Housing_number:=((STD_Coefficient_Private_Housing[1,1]*T1_number+STD_Coefficient_Private_Housing[1,2]*T2_number+
 STD_Coefficient_Private_Housing[1,3]*T3_number+STD_Coefficient_Private_Housing[1,4]*T4_number+STD_Coefficient_Private_Housing[1,5]*T5_number+
 STD_Coefficient_Private_Housing[1,6]*T6_number)+(STD_Coefficient_Social_Housing[1,1]*T1_number+STD_Coefficient_Social_Housing[1,2]*T2_number+
 STD_Coefficient_Social_Housing[1,3]*T3_number+STD_Coefficient_Social_Housing[1,4]*T4_number+STD_Coefficient_Social_Housing[1,5]*T5_number+
 STD_Coefficient_Social_Housing[1,6]*T6_number))/2;
 end if;

drawoff_flow_rate:=Vm*Standard_Housing_number*Coefficient_Hour[Day,Hour]*Coefficient_Day[1,Day]*Coefficient_Month[1,Month]*(40+273.15 - T_cold)/(T_hot - T_cold)/3600*Gain;

  annotation (Icon(coordinateSystem(preserveAspectRatio=false), graphics={
        Rectangle(
          extent={{-100,100},{100,-100}},
          lineColor={28,108,200},
          lineThickness=1),
        Bitmap(
          extent={{-82,-14},{6,98}},
          imageSource="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",
          fileName="modelica://Soutirage_ECS_LC/Immeuble.PNG"),
        Bitmap(
          extent={{-22,-100},{90,2}},
          imageSource="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"
               + "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"
               + "RX+/9Vu/1fKAk5a6aGOoVCjoKuTK0CJw2c3lbHAvZ5c2i/bpcsren9+1DxZ37bP1lF3ZLdpNoHEL9e5HD3OEGkMTulZKNdvnARe9K1fdhCjuamz6dKDIzfQG4vOG2nM9h2Qnh+xFnq/CaYVE6jLewgaXczWbxR5HU1Ub2K9Yz27ZurZD6yR0f0zFeGMta9dXVAGm7OZC0p5s5m2JUF/etBZw9y5uznfWJG7oryVU9PcywKLuZIdKRd3KfEcKSRSmqBbYCmo+mnGRh7Scxd3MVm09V7HNfIXfqrYFMHJBwYpSpWRFzlfCA9KDbkDEx4hwjXjchIByACp4SOdQOddzSBWeexFuW9iMxphorpjmC2n+kBpZS/JmqCCx5SLed4b9tCh7kopuH3vexRtZzedtPdByk2qoxdPhNwEp1IDKUGNzOF/Tdc+CYqDo70io6O9Fh0LRaEYeDoXaBwO5nvbKCC5aOcvprf31yf8Vqb5fY0g2Xk80NL4JEHr4kgwg/o6imanRdRWGRWLbuc51jBqhidtVvVLyIRF1NQaz8Zt74VFIH9u0OgfCarQAtjycWPot6gHClvXJ/2dF4kTzX1uo6E+Nty97YNy5znWu0y9xQXw4/HcsVOI/HSwi6USvYkj/uc51rlcrlXuVf3GgFUziv+eGyvnf+d/53/nf8/ydQ+X87/zv/O8E/8z+/3fvnkvVxtLXAAAAAElFTkSuQmCC",
          fileName="modelica://Soutirage_ECS_LC/Baignoire.PNG")}),
                                                                 Diagram(
        coordinateSystem(preserveAspectRatio=false)),
    Documentation(revisions="<html>
</html>", info="<html>
<p><br><u><b>Hypothesis and equations</b></u></p>
<p>Collective tapping profile for DHW.</p>
<p><u><b>Bibliography</b></u></p>
<p>Documentation : Technical guide of ADEME <a href=\"//BuildSysPro/Resources/Documentation/ADEME-besoin_ECS_habitat_individuel_et_collectif.pdf\">see here</a> picture number 22 page 21.</p>
<p><br><u><b>Instructions for use</b></u></p>
<p>none</p>
<p><u><b>Known limits / Use precautions</b></u></p>
<p>none</p>
<p><u><b>Validations</b></u></p>
<p>Validated model - none</p>
<p><b>--------------------------------------------------------------<br>
Licensed by EDF under a 3-clause BSD-license<br>
Copyright &copy; EDF 2009 - 2021<br>
BuildSysPro version 3.5.0<br>
Author : Hugues BOSCHE, EDF (2023)<br>
--------------------------------------------------------------</b></p>
</html>"),
    experiment(
      StopTime=36000,
      Interval=60,
      __Dymola_Algorithm="Dassl"));
end DHW_CollectiveHousing_PACTE;
