within ThermofluidStream.UsersGuide;
class References "References"
  extends Modelica.Icons.References;

  annotation (DocumentationClass=true, Documentation(info="<html>
<p>
This section gives an overview of the literature related to the library and its modeling approach.
The citation rules for publishing work that is based on this library can be found in the project&apos;s
<a href=\"https://github.com/DLR-SR/ThermofluidStream.git\">GitHub repository</a> frontpage.
</p>

<h4>Literature</h4>
<p>
<strong>References referring directly to this library</strong>
</p>
<ul>
  <li>
    Zimmer, D. (2020).
    &quot;Robust object-oriented formulation of directed thermofluid stream networks&quot;.
    In: Mathematical and Computer Modelling of Dynamical Systems 26.3, pp. 204&ndash;233.<br>
    <a href=\"https://doi.org/10.1080/13873954.2020.1757726\">10.1080/13873954.2020.1757726</a>.
  </li>
  <li>
    Zimmer, D., N. Weber, M. Mei&szlig;ner (2021).
    &quot;Robust Simulation of Stream-Dominated Thermo-Fluid Systems: From Directed to Non-Directed Flows&quot;.
    In: Simulation Notes Europe, Volume 31(4):177-184.<br>
    <a href=\"https://www.sne-journal.org/sne-volumes/volume-31/sne-314-articles/robust-simulation-of-stream-dominated-thermo-fluid-systems-from-directed-to-non-directed-flows\">10.11128/sne.31.tn.10581</a>.
  </li>
  <li>
    Zimmer, D., M. Mei&szlig;ner, N. Weber (2021).
    &quot;The DLR ThermoFluidStream Library&quot;.
    In: 14th International Modelica Conference, Link&ouml;ping, Sweden.<br>
    <a href=\"https://doi.org/10.3384/ecp21181225\">https://doi.org/10.3384/ecp21181225</a>.
  </li>
  <li>
    Zimmer, D., M. Mei&szlig;ner, N. Weber (2022).
    &quot;The DLR ThermoFluid Stream Library&quot; <em>Electronics</em> 11, no.22 :3790.<br>
    <a href=\"https://doi.org/10.3390/electronics11223790\">https://doi.org/10.3390/electronics11223790</a>.
  </li>
  <li>
    Mei&szlig;ner, M., D. Zimmer (2022).
    &quot;Robust Modeling of Volumes for Dynamic Simulations of Thermo-Fluid Stream Networks&quot;.
    In: IFAC Papers Online Volume 55 Issue 20.<br>
    <a href=\"https://doi.org/10.1016/j.ifacol.2022.09.106\">https://doi.org/10.1016/j.ifacol.2022.09.106</a>.
  </li>
</ul>

<strong>Further background references on the methodology</strong>
<ul>
  <li>
    Zimmer, D., D. Bender, A. Pollok (2018).
    &quot;Robust Modeling of Directed Thermofluid Flows in Complex Networks&quot;.
    In: Proceedings of the 2nd Japanese Modelica Conference (Tokyo, Japan).<br>
    <a href=\"https://elib.dlr.de/120701/1/Japan2018Robust.pdf\">https://elib.dlr.de/120701/1/Japan2018Robust.pdf</a>
  </li>
  <li>
    Zimmer, D. (2019a).
    &quot;Robust Simulation of StreamDominated Thermo-Fluid Systems:
    From Unidirectional to Bidirectional Applications&quot;.
    In: EUROSIM Congress (Logrono, Spain).<br>
    <a href=\"https://www.researchgate.net/publication/337812690_Robust_Simulation_of_Stream-Dominated_Thermo-Fluid_Systems_From_Unidirectional_to_Bidirectional_Applications\">URL.</a>
  </li>
  <li>
    Zimmer, D. (2019b).
    &quot;Towards hard real-time simulation of complex fluid networks&quot;.
    In: Proceedings of the 13th International Modelica Conference (Regensburg, Germany).
    Link&ouml;ping University Electronic Press, Link&ouml;pings universitet, pp. 579&ndash;587. <br>
    <a href=\"https://ep.liu.se/ecp/157/059/ecp19157059.pdf\">https://ep.liu.se/ecp/157/059/ecp19157059.pdf</a>
  </li>
  <li>
    Otter, M. et al. (2019).
    &quot;Thermodynamic Property and Fluid Modeling with Modern Programming Language Constructs&quot;.
    In: Proceedings of the 13th International Modelica Conference (Regensburg, Germany).
    Link&ouml;ping University Electronic Press, Link&ouml;pings universitet <br>
    <a href=\"https://ep.liu.se/ecp/157/060/ecp19157060.pdf\">https://ep.liu.se/ecp/157/060/ecp19157060.pdf</a>
  </li>
</ul>
</html>", revisions="<html>
<p><img src=\"modelica:/ThermofluidStream/Resources/dlr_logo.png\"/>(c) 2020-2021, DLR, Institute of System Dynamics and Control</p>
</html>"));
end References;
