within ThermofluidStream.Media.myMedia;
package IdealGases "Data and models of ideal gases (single, fixed and dynamic mixtures) from NASA source"
  extends Modelica.Icons.VariantsPackage;

  annotation (Documentation(info="<html>
<p>This package contains data for the 1241 ideal gases from</p>
<blockquote>
  McBride B.J., Zehe M.J., and Gordon S. (2002): <strong>NASA Glenn Coefficients
  for Calculating Thermodynamic Properties of Individual Species</strong>. NASA
  report TP-2002-211556
</blockquote>
<p>Medium models for some of these gases are available in package
<a href=\"modelica://Modelica.Media.IdealGases.SingleGases\">IdealGases.SingleGases</a>
and some examples for mixtures are available in package <a href=\"modelica://Modelica.Media.IdealGases.MixtureGases\">IdealGases.MixtureGases</a>
</p>

<h4>Using and Adapting Medium Models</h4>
<p>
The data records allow computing the ideal gas specific enthalpy, specific entropy and heat capacity of the substances listed below. From them, even the Gibbs energy and equilibrium constants for reactions can be computed. Critical data that is needed for computing the viscosity and thermal conductivity is not included. In order to add mixtures or single substance medium packages that are
subtypes of
<a href=\"modelica://Modelica.Media.Interfaces.PartialMedium\">Interfaces.PartialMedium</a>
(i.e., can be utilized at all places where PartialMedium is defined),
a few additional steps have to be performed:
</p>
<ol>
<li>
All single gas media need to define a constant instance of record
<a href=\"modelica://Modelica.Media.Interfaces.PartialMedium.FluidConstants\">IdealGases.Common.SingleGasNasa.FluidConstants</a>.
For 37 ideal gases such records are provided in package
<a href=\"modelica://Modelica.Media.IdealGases.Common.FluidData\">IdealGases.Common.FluidData</a>.
For the other gases, such a record instance has to be provided by the user, e.g., by getting
the data from a commercial or public data base. A public source of the needed data is for example the <a href=\"http://webbook.nist.gov/chemistry/\"> NIST Chemistry WebBook</a></li>

<li>When the data is available, and a user has an instance of a
<a href=\"modelica://Modelica.Media.Interfaces.PartialMedium.FluidConstants\">FluidConstants</a> record filled with data, a medium package has to be written. Note that only the dipole moment, the acentric factor and critical data are necessary for the viscosity and thermal conductivity functions.</li>
<li><ul>
<li>For single components, a new package following the pattern in
<a href=\"modelica://Modelica.Media.IdealGases.SingleGases\">IdealGases.SingleGases</a> has to be created, pointing both to a data record for cp and to a user-defined fluidConstants record.</li>
<li>For mixtures of several components, a new package following the pattern in
<a href=\"modelica://Modelica.Media.IdealGases.MixtureGases\">IdealGases.MixtureGases</a> has to be created, building an array of data records for cp and an array of (partly) user-defined fluidConstants records.</li>
</ul></li>
</ol>
<p>Note that many properties can computed for the full set of 1241 gases listed below, but due to the missing viscosity and thermal conductivity functions, no fully Modelica.Media-compliant media can be defined.</p>
<p>
Data records for heat capacity, specific enthalpy and specific entropy exist for the following substances and ions:
</p>
<blockquote><pre>
Ag        BaOH+           C2H4O_ethylen_o DF      In2I4    Nb      ScO2
Ag+       Ba_OH_2         CH3CHO_ethanal  DOCl    In2I6    Nb+     Sc2O
Ag-       BaS             CH3COOH         DO2     In2O     Nb-     Sc2O2
Air       Ba2             OHCH2COOH       DO2-    K        NbCl5   Si
Al        Be              C2H5            D2      K+       NbO     Si+
Al+       Be+             C2H5Br          D2+     K-       NbOCl3  Si-
Al-       Be++            C2H6            D2-     KAlF4    NbO2    SiBr
AlBr      BeBr            CH3N2CH3        D2O     KBO2     Ne      SiBr2
AlBr2     BeBr2           C2H5OH          D2O2    KBr      Ne+     SiBr3
AlBr3     BeCl            CH3OCH3         D2S     KCN      Ni      SiBr4
AlC       BeCl2           CH3O2CH3        e-      KCl      Ni+     SiC
AlC2      BeF             CCN             F       KF       Ni-     SiC2
AlCl      BeF2            CNC             F+      KH       NiCl    SiCl
AlCl+     BeH             OCCN            F-      KI       NiCl2   SiCl2
AlCl2     BeH+            C2N2            FCN     Kli      NiO     SiCl3
AlCl3     BeH2            C2O             FCO     KNO2     NiS     SiCl4
AlF       BeI             C3              FO      KNO3     O       SiF
AlF+      BeI2            C3H3_1_propynl  FO2_FOO KNa      O+      SiFCl
AlFCl     BeN             C3H3_2_propynl  FO2_OFO KO       O-      SiF2
AlFCl2    BeO             C3H4_allene     F2      KOH      OD      SiF3
AlF2      BeOH            C3H4_propyne    F2O     K2       OD-     SiF4
AlF2-     BeOH+           C3H4_cyclo      F2O2    K2+      OH      SiH
AlF2Cl    Be_OH_2         C3H5_allyl      FS2F    K2Br2    OH+     SiH+
AlF3      BeS             C3H6_propylene  Fe      K2CO3    OH-     SiHBr3
AlF4-     Be2             C3H6_cyclo      Fe+     K2C2N2   O2      SiHCl
AlH       Be2Cl4          C3H6O_propylox  Fe_CO_5 K2Cl2    O2+     SiHCl3
AlHCl     Be2F4           C3H6O_acetone   FeCl    K2F2     O2-     SiHF
AlHCl2    Be2O            C3H6O_propanal  FeCl2   K2I2     O3      SiHF3
AlHF      Be2OF2          C3H7_n_propyl   FeCl3   K2O      P       SiHI3
AlHFCl    Be2O2           C3H7_i_propyl   FeO     K2O+     P+      SiH2
AlHF2     Be3O3           C3H8            Fe_OH_2 K2O2     P-      SiH2Br2
AlH2      Be4O4           C3H8O_1propanol Fe2Cl4  K2O2H2   PCl     SiH2Cl2
AlH2Cl    Br              C3H8O_2propanol Fe2Cl6  K2SO4    PCl2    SiH2F2
AlH2F     Br+             CNCOCN          Ga      Kr       PCl2-   SiH2I2
AlH3      Br-             C3O2            Ga+     Kr+      PCl3    SiH3
AlI       BrCl            C4              GaBr    li       PCl5    SiH3Br
AlI2      BrF             C4H2_butadiyne  GaBr2   li+      PF      SiH3Cl
AlI3      BrF3            C4H4_1_3-cyclo  GaBr3   li-      PF+     SiH3F
AlN       BrF5            C4H6_butadiene  GaCl    liAlF4   PF-     SiH3I
AlO       BrO             C4H6_1butyne    GaCl2   liBO2    PFCl    SiH4
AlO+      OBrO            C4H6_2butyne    GaCl3   liBr     PFCl-   SiI
AlO-      BrOO            C4H6_cyclo      GaF     liCl     PFCl2   SiI2
AlOCl     BrO3            C4H8_1_butene   GaF2    liF      PFCl4   SiN
AlOCl2    Br2             C4H8_cis2_buten GaF3    liH      PF2     SiO
AlOF      BrBrO           C4H8_isobutene  GaH     liI      PF2-    SiO2
AlOF2     BrOBr           C4H8_cyclo      GaI     liN      PF2Cl   SiS
AlOF2-    C               C4H9_n_butyl    GaI2    liNO2    PF2Cl3  SiS2
AlOH      C+              C4H9_i_butyl    GaI3    liNO3    PF3     Si2
AlOHCl    C-              C4H9_s_butyl    GaO     liO      PF3Cl2  Si2C
AlOHCl2   CBr             C4H9_t_butyl    GaOH    liOF     PF4Cl   Si2F6
AlOHF     CBr2            C4H10_n_butane  Ga2Br2  liOH     PF5     Si2N
AlOHF2    CBr3            C4H10_isobutane Ga2Br4  liON     PH      Si3
AlO2      CBr4            C4N2            Ga2Br6  li2      PH2     Sn
AlO2-     CCl             C5              Ga2Cl2  li2+     PH2-    Sn+
Al_OH_2   CCl2            C5H6_1_3cyclo   Ga2Cl4  li2Br2   PH3     Sn-
Al_OH_2Cl CCl2Br2         C5H8_cyclo      Ga2Cl6  li2F2    PN      SnBr
Al_OH_2F  CCl3            C5H10_1_pentene Ga2F2   li2I2    PO      SnBr2
Al_OH_3   CCl3Br          C5H10_cyclo     Ga2F4   li2O     PO-     SnBr3
AlS       CCl4            C5H11_pentyl    Ga2F6   li2O+    POCl3   SnBr4
AlS2      CF              C5H11_t_pentyl  Ga2I2   li2O2    POFCl2  SnCl
Al2       CF+             C5H12_n_pentane Ga2I4   li2O2H2  POF2Cl  SnCl2
Al2Br6    CFBr3           C5H12_i_pentane Ga2I6   li2SO4   POF3    SnCl3
Al2C2     CFCl            CH3C_CH3_2CH3   Ga2O    li3+     PO2     SnCl4
Al2Cl6    CFClBr2         C6D5_phenyl     Ge      li3Br3   PO2-    SnF
Al2F6     CFCl2           C6D6            Ge+     li3Cl3   PS      SnF2
Al2I6     CFCl2Br         C6H2            Ge-     li3F3    P2      SnF3
Al2O      CFCl3           C6H5_phenyl     GeBr    li3I3    P2O3    SnF4
Al2O+     CF2             C6H5O_phenoxy   GeBr2   Mg       P2O4    SnI
Al2O2     CF2+            C6H6            GeBr3   Mg+      P2O5    SnI2
Al2O2+    CF2Br2          C6H5OH_phenol   GeBr4   MgBr     P3      SnI3
Al2O3     CF2Cl           C6H10_cyclo     GeCl    MgBr2    P3O6    SnI4
Al2S      CF2ClBr         C6H12_1_hexene  GeCl2   MgCl     P4      SnO
Al2S2     CF2Cl2          C6H12_cyclo     GeCl3   MgCl+    P4O6    SnO2
Ar        CF3             C6H13_n_hexyl   GeCl4   MgCl2    P4O7    SnS
Ar+       CF3+            C6H14_n_hexane  GeF     MgF      P4O8    SnS2
B         CF3Br           C7H7_benzyl     GeF2    MgF+     P4O9    Sn2
B+        CF3Cl           C7H8            GeF3    MgF2     P4O10   Sr
B-        CF4             C7H8O_cresol_mx GeF4    MgF2+    Pb      Sr+
BBr       CH+             C7H14_1_heptene GeH4    MgH      Pb+     SrBr
BBr2      CHBr3           C7H15_n_heptyl  GeI     MgI      Pb-     SrBr2
BBr3      CHCl            C7H16_n_heptane GeO     MgI2     PbBr    SrCl
BC        CHClBr2         C7H16_2_methylh GeO2    MgN      PbBr2   SrCl+
BC2       CHCl2           C8H8_styrene    GeS     MgO      PbBr3   SrCl2
BCl       CHCl2Br         C8H10_ethylbenz GeS2    MgOH     PbBr4   SrF
BCl+      CHCl3           C8H16_1_octene  Ge2     MgOH+    PbCl    SrF+
BClOH     CHF             C8H17_n_octyl   H       Mg_OH_2  PbCl2   SrF2
BCl_OH_2  CHFBr2          C8H18_n_octane  H+      MgS      PbCl3   SrH
BCl2      CHFCl           C8H18_isooctane H-      Mg2      PbCl4   SrI
BCl2+     CHFClBr         C9H19_n_nonyl   HAlO    Mg2F4    PbF     SrI2
BCl2OH    CHFCl2          C10H8_naphthale HAlO2   Mn       PbF2    SrO
BF        CHF2            C10H21_n_decyl  HBO     Mn+      PbF3    SrOH
BFCl      CHF2Br          C12H9_o_bipheny HBO+    Mo       PbF4    SrOH+
BFCl2     CHF2Cl          C12H10_biphenyl HBO2    Mo+      PbI     Sr_OH_2
BFOH      CHF3            Ca              HBS     Mo-      PbI2    SrS
BF_OH_2   CHI3            Ca+             HBS+    MoO      PbI3    Sr2
BF2       CH2             CaBr            HCN     MoO2     PbI4    Ta
BF2+      CH2Br2          CaBr2           HCO     MoO3     PbO     Ta+
BF2-      CH2Cl           CaCl            HCO+    MoO3-    PbO2    Ta-
BF2Cl     CH2ClBr         CaCl+           HCCN    Mo2O6    PbS     TaCl5
BF2OH     CH2Cl2          CaCl2           HCCO    Mo3O9    PbS2    TaO
BF3       CH2F            CaF             HCl     Mo4O12   Rb      TaO2
BF4-      CH2FBr          CaF+            HD      Mo5O15   Rb+     Ti
BH        CH2FCl          CaF2            HD+     N        Rb-     Ti+
BHCl      CH2F2           CaH             HDO     N+       RbBO2   Ti-
BHCl2     CH2I2           CaI             HDO2    N-       RbBr    TiCl
BHF       CH3             CaI2            HF      NCO      RbCl    TiCl2
BHFCl     CH3Br           CaO             HI      ND       RbF     TiCl3
BHF2      CH3Cl           CaO+            HNC     ND2      RbH     TiCl4
BH2       CH3F            CaOH            HNCO    ND3      RbI     TiO
BH2Cl     CH3I            CaOH+           HNO     NF       RbK     TiO+
BH2F      CH2OH           Ca_OH_2         HNO2    NF2      Rbli    TiOCl
BH3       CH2OH+          CaS             HNO3    NF3      RbNO2   TiOCl2
BH3NH3    CH3O            Ca2             HOCl    NH       RbNO3   TiO2
BH4       CH4             Cd              HOF     NH+      RbNa    U
BI        CH3OH           Cd+             HO2     NHF      RbO     UF
BI2       CH3OOH          Cl              HO2-    NHF2     RbOH    UF+
BI3       CI              Cl+             HPO     NH2      Rb2Br2  UF-
BN        CI2             Cl-             HSO3F   NH2F     Rb2Cl2  UF2
BO        CI3             ClCN            H2      NH3      Rb2F2   UF2+
BO-       CI4             ClF             H2+     NH2OH    Rb2I2   UF2-
BOCl      CN              ClF3            H2-     NH4+     Rb2O    UF3
BOCl2     CN+             ClF5            HBOH    NO       Rb2O2   UF3+
BOF       CN-             ClO             HCOOH   NOCl     Rb2O2H2 UF3-
BOF2      CNN             ClO2            H2F2    NOF      Rb2SO4  UF4
BOH       CO              Cl2             H2O     NOF3     Rn      UF4+
BO2       CO+             Cl2O            H2O+    NO2      Rn+     UF4-
BO2-      COCl            Co              H2O2    NO2-     S       UF5
B_OH_2    COCl2           Co+             H2S     NO2Cl    S+      UF5+
BS        COFCl           Co-             H2SO4   NO2F     S-      UF5-
BS2       COF2            Cr              H2BOH   NO3      SCl     UF6
B2        COHCl           Cr+             HB_OH_2 NO3-     SCl2    UF6-
B2C       COHF            Cr-             H3BO3   NO3F     SCl2+   UO
B2Cl4     COS             CrN             H3B3O3  N2       SD      UO+
B2F4      CO2             CrO             H3B3O6  N2+      SF      UOF
B2H       CO2+            CrO2            H3F3    N2-      SF+     UOF2
B2H2      COOH            CrO3            H3O+    NCN      SF-     UOF3
B2H3      CP              CrO3-           H4F4    N2D2_cis SF2     UOF4
B2H3_db   CS              Cs              H5F5    N2F2     SF2+    UO2
B2H4      CS2             Cs+             H6F6    N2F4     SF2-    UO2+
B2H4_db   C2              Cs-             H7F7    N2H2     SF3     UO2-
B2H5      C2+             CsBO2           He      NH2NO2   SF3+    UO2F
B2H5_db   C2-             CsBr            He+     N2H4     SF3-    UO2F2
B2H6      C2Cl            CsCl            Hg      N2O      SF4     UO3
B2O       C2Cl2           CsF             Hg+     N2O+     SF4+    UO3-
B2O2      C2Cl3           CsH             HgBr2   N2O3     SF4-    V
B2O3      C2Cl4           CsI             I       N2O4     SF5     V+
B2_OH_4   C2Cl6           Csli            I+      N2O5     SF5+    V-
B2S       C2F             CsNO2           I-      N3       SF5-    VCl4
B2S2      C2FCl           CsNO3           IF5     N3H      SF6     VN
B2S3      C2FCl3          CsNa            IF7     Na       SF6-    VO
B3H7_C2v  C2F2            CsO             I2      Na+      SH      VO2
B3H7_Cs   C2F2Cl2         CsOH            In      Na-      SH-     V4O10
B3H9      C2F3            CsRb            In+     NaAlF4   SN      W
B3N3H6    C2F3Cl          Cs2             InBr    NaBO2    SO      W+
B3O3Cl3   C2F4            Cs2Br2          InBr2   NaBr     SO-     W-
B3O3FCl2  C2F6            Cs2CO3          InBr3   NaCN     SOF2    WCl6
B3O3F2Cl  C2H             Cs2Cl2          InCl    NaCl     SO2     WO
B3O3F3    C2HCl           Cs2F2           InCl2   NaF      SO2-    WOCl4
B4H4      C2HCl3          Cs2I2           InCl3   NaH      SO2Cl2  WO2
B4H10     C2HF            Cs2O            InF     NaI      SO2FCl  WO2Cl2
B4H12     C2HFCl2         Cs2O+           InF2    Nali     SO2F2   WO3
B5H9      C2HF2Cl         Cs2O2           InF3    NaNO2    SO3     WO3-
Ba        C2HF3           Cs2O2H2         InH     NaNO3    S2      Xe
Ba+       C2H2_vinylidene Cs2SO4          InI     NaO      S2-     Xe+
BaBr      C2H2Cl2         Cu              InI2    NaOH     S2Cl2   Zn
BaBr2     C2H2FCl         Cu+             InI3    NaOH+    S2F2    Zn+
BaCl      C2H2F2          Cu-             InO     Na2      S2O     Zr
BaCl+     CH2CO_ketene    CuCl            InOH    Na2Br2   S3      Zr+
BaCl2     O_CH_2O         CuF             In2Br2  Na2Cl2   S4      Zr-
BaF       HO_CO_2OH       CuF2            In2Br4  Na2F2    S5      ZrN
BaF+      C2H3_vinyl      CuO             In2Br6  Na2I2    S6      ZrO
BaF2      CH2Br-COOH      Cu2             In2Cl2  Na2O     S7      ZrO+
BaH       C2H3Cl          Cu3Cl3          In2Cl4  Na2O+    S8      ZrO2
BaI       CH2Cl-COOH      D               In2Cl6  Na2O2    Sc
BaI2      C2H3F           D+              In2F2   Na2O2H2  Sc+
BaO       CH3CN           D-              In2F4   Na2SO4   Sc-
BaO+      CH3CO_acetyl    DBr             In2F6   Na3Cl3   ScO
BaOH      C2H4            DCl             In2I2   Na3F3    ScO+
</pre></blockquote></html>"));
end IdealGases;
