within TILMediaWrapper.VLEFluidWrapper;
package SubstanceRecords
  record Refprop_R513A_MIX "Refprop.R513A.MIX  at constant composition"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"Refprop.R513A.MIX"},
      final mixingRatio_propertyCalculation={1});
  end Refprop_R513A_MIX;

  record TILMedia_R1336MZZ "TILMedia.R1336MZZ"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.R1336MZZ"},
      final mixingRatio_propertyCalculation={1});
  end TILMedia_R1336MZZ;

  record Refprop_METHANOL "Refprop.METHANOL.FLD"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"Refprop.METHANOL.FLD"},
      final mixingRatio_propertyCalculation={1});
  end Refprop_METHANOL;

  record VDIWA2006_METHANOL  "VDIWA2006.METHANOL"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"VDIWA2006.METHANOL"},
      final mixingRatio_propertyCalculation={1});
  end VDIWA2006_METHANOL;

  record CoolProp_Methanol "CoolProp.Methanol"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.Methanol"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_Methanol;

  record VDIWA2006VDIWA2006_HYDROGEN  "VDIWA2006.HYDROGEN"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"VDIWA2006.HYDROGEN"},
      final mixingRatio_propertyCalculation={1});
  end VDIWA2006VDIWA2006_HYDROGEN;

  record TILMedia_Hydrogen "TILMedia.Hydrogen"
    extends PartialModels.BaseVLEFluid(
      final vleFluidNames={"TILMedia.Hydrogen"},
      final mixingRatio_propertyCalculation={1},
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1);
  end TILMedia_Hydrogen;

  record CoolProp_Hydrogen "CoolProp.Hydrogen"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.Hydrogen"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_Hydrogen;

  record Refprop_HYDROGEN_FLD  "Refprop.HYDROGEN.FLD "
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"Refprop.HYDROGEN.FLD"},
      final mixingRatio_propertyCalculation={1});
  end Refprop_HYDROGEN_FLD;

  record Refprop_R1336MZZZ_FLD   "Refprop.R1336MZZZ.FLD "
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"Refprop.R1336MZZZ.FLD"},
      final mixingRatio_propertyCalculation={1});
  end Refprop_R1336MZZZ_FLD;

  record TILMedia_R1233ZDE "TILMedia.R1233ZDE"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.R1233ZDE"},
      final mixingRatio_propertyCalculation={1});
  end TILMedia_R1233ZDE;

  record Refprop_R1233ZDE_FLD   "Refprop.R1233ZDE.FLD "
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"Refprop.R1233ZDE.FLD"},
      final mixingRatio_propertyCalculation={1});
  end Refprop_R1233ZDE_FLD;

  record CoolProp_R1233zd_E "CoolProp.R1233zd(E)"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.R1233zd(E)"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_R1233zd_E;

  record TILMedia_R1234ZEZ "TILMedia.R1234ZEZ"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.R1234ZEZ"},
      final mixingRatio_propertyCalculation={1});
  end TILMedia_R1234ZEZ;

  record Refprop_R1234ZEZ_FLD   "Refprop.R1234ZEZ.FLD "
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"Refprop.R1234ZEZ.FLD"},
      final mixingRatio_propertyCalculation={1});
  end Refprop_R1234ZEZ_FLD;

  record CoolProp_R1234ze_Z "CoolProp.R1234ze(Z)"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.R1234ze(Z)"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_R1234ze_Z;

  record TILMedia_R1234ZEE "TILMedia.R1234ZEE"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.R1234ZEE"},
      final mixingRatio_propertyCalculation={1});
  end TILMedia_R1234ZEE;

  record Refprop_R1234ZEE_FLD   "Refprop.R1234ZEE.FLD "
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"Refprop.R1234ZEE.FLD"},
      final mixingRatio_propertyCalculation={1});
  end Refprop_R1234ZEE_FLD;

  record CoolProp_R1234ze_E "CoolProp.R1234ze(E)"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.R1234ze(E)"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_R1234ze_E;

  record CoolProp_R1234yf "CoolProp.R1234yf"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.R1234yf"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_R1234yf;

  record TILMedia_N_BUTANE "TILMedia.N-BUTANE"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.N-BUTANE"},
      final mixingRatio_propertyCalculation={1});
  end TILMedia_N_BUTANE;

  record CoolProp_n_Butane "CoolProp.n-Butane"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.n-Butane"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_n_Butane;

  record TILMedia_ISOBUTANE "TILMedia.ISOBUTANE"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.ISOBUTANE"},
      final mixingRatio_propertyCalculation={1});
  end TILMedia_ISOBUTANE;

  record CoolProp_IsoButane "CoolProp.IsoButane"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"CoolProp.IsoButane"},
      final mixingRatio_propertyCalculation={1});
  end CoolProp_IsoButane;
  // there is also REFPROP-> Butane and VDIWA2006->Butane, but i dont know which version

  record USER_METHANOL "Refprop methanol as FE2 Equation"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.User_Methanol"},
      final mixingRatio_propertyCalculation={1});

      //to use this copy the VLEFluid_METHANOL.json into C:\ProgramData\TLK-Thermo GmbH\TILMedia\<VERSION>\
  end USER_METHANOL;

  record USER_R1234ZEE
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.User_R1234ZEE"},
      final mixingRatio_propertyCalculation={1});
  end USER_R1234ZEE;

  record TILMedia_METHANOL "TILMedia methanol"
    extends PartialModels.BaseVLEFluid(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final vleFluidNames={"TILMedia.METHANOL"},
      final mixingRatio_propertyCalculation={1});

      //to use this copy the VLEFluid_METHANOL.json into C:\ProgramData\TLK-Thermo GmbH\TILMedia\<VERSION>\
  end TILMedia_METHANOL;
end SubstanceRecords;
