Thanks for considering to contribute to the DLR Thermofluid Stream Library.

You can contribute either by reporting an issue or by contributing code.

When filing an issue, please include all information necessary to reproduce,
and state what package is affected.

The workflow for contributing code depends on whether you are a collaborator
with push rights, or an outside collaborator.

The [workflow for outside collaborators](https://guides.github.com/activities/forking/) is usually as follows:

1. Fork the repository to your account by
   [using the `Fork` button](https://help.github.com/articles/fork-a-repo/).
2. Clone the forked repository to your computer.
3. Create a new topic branch and give it a meaningful name,
   like, e.g., `issue2161-fix-formula`.
4. Do your code changes and commit them, one change per commit.
   Single commits can be copied to other branches.
   Multiple commits can be squashed into one, but splitting is difficult.
5. Once you are done, push your branch to your fork.
6. Go to the upstream ThermofluidStream repository and submit a
   [Pull Request](https://help.github.com/articles/about-pull-requests/) (PR).
   * If the PR is related to a certain issue, reference it by its number like this: #2161.
   * Once a pull request is opened, you can discuss and
   [review](https://help.github.com/articles/about-pull-request-reviews/)
   the potential changes with collaborators and add follow-up commits before
   the changes are merged into the repository.
   * Please mark the authorship of the content you submitted. By submitting, you agree to the overall [license of the library](https://github.com/DLR-SR/ThermofluidStream/blob/main/LICENSE). 
   <!-- * If you have not already signed the Modelica Association Contributor License Agreement (CLA) you need to do so one-time.
   You can sign the CLA electronically using the CLA Assistant service and your GitHub account. There is no need to scan and send any documents by mail. -->
7. Update your branch with the requested changes. If necessary, merge the latest
   master into your branch and solve all merge conflicts in your branch.
