within BikeTrailer.Examples;
model TestTrailerWithoutDrive "Test the trailer without drive"
  extends Modelica.Icons.Example;
  Components.Trailer trailer(
    trailerData=trailerData,
    useWindInput=true,
    usecrInput=true,
    useInclinationInput=true,
    s(fixed=true))
    annotation (Placement(transformation(extent={{10,-10},{30,10}})));
  parameter DataRecords.TrailerData trailerData
    annotation (Placement(transformation(extent={{-10,60},{10,80}})));
  Modelica.Blocks.Math.Gain from_kmh(k = 1/3.6) annotation (
    Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-40, 0})));
  Modelica.Mechanics.Translational.Sources.Speed bike(exact = false, f_crit = 100, s(fixed = false)) annotation (
    Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-10, 0})));
  Modelica.Blocks.Sources.CombiTimeTable track(table=trackData.trackTable,
      extrapolation=Modelica.Blocks.Types.Extrapolation.Periodic)
    annotation (Placement(transformation(
        extent={{-10,-10},{10,10}},
        rotation=0,
        origin={-80,0})));
  parameter DataRecords.TrackData trackData
    annotation (Placement(transformation(extent={{-90,20},{-70,40}})));
equation
  connect(from_kmh.y, bike.v_ref) annotation (
    Line(points = {{-29, 0}, {-22, 0}}, color = {0, 0, 127}));
  connect(bike.flange, trailer.flange)
    annotation (Line(points={{0,0},{10,0}}, color={0,127,0}));
  connect(track.y[1], from_kmh.u)
    annotation (Line(points={{-69,0},{-52,0}}, color={0,0,127}));
  connect(track.y[2], trailer.vWind) annotation (Line(points={{-69,0},{-60,0},{
          -60,-20},{14,-20},{14,-12}}, color={0,0,127}));
  connect(track.y[3], trailer.cr) annotation (Line(points={{-69,0},{-60,0},{-60,
          -20},{20,-20},{20,-12}}, color={0,0,127}));
  connect(track.y[4], trailer.inclination) annotation (Line(points={{-69,0},{
          -60,0},{-60,-20},{26,-20},{26,-12}}, color={0,0,127}));
  annotation (experiment(
      StopTime=420,
      Interval=0.0005,
      Tolerance=1e-06),
    Documentation(info="<html>
<p>
The bike is modeled as a prescribed speed, i.e. the biker is strong enough to reach the prescribed speed. 
The force between bike and trailer is measured but not compensated (<code>tauRef=0</code>).
</p>
</html>"));
end TestTrailerWithoutDrive;
